package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.employees.ResetPassWordRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformResetAuthenticateStatusRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformResetPasswordRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformUpdateUserBasicRequest;
import com.bcxin.api.interfaces.tenants.responses.EmployeeBasicResponse;
import com.bcxin.rest.web.apis.utils.CacheUtil;
import com.bcxin.rest.web.apis.utils.IPUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * description：平台操作接口
 * author：linchunpeng
 * date：2024/11/12
 */
@RestController
@RequestMapping("/platform/")
public class PlatformController extends ControllerAbstract{
    private final UserRpcProvider userRpcProvider;
    private final CacheV2Provider cacheV2Provider;

    public PlatformController(UserRpcProvider userRpcProvider, CacheV2Provider cacheV2Provider) {
        this.userRpcProvider = userRpcProvider;
        this.cacheV2Provider = cacheV2Provider;
    }

    @ApiOperation(value = "变更用户姓名/手机信息")
    @PutMapping("/update/user/basic")
    public ResponseEntity updateUserBasic(@RequestBody PlatformUpdateUserBasicRequest request, HttpServletRequest httpServletRequest) {
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        this.userRpcProvider.updateUserBasicByPlatform(request);
        this.cacheV2Provider.del(CacheUtil.getTenantUserDeletedCachedKeys(request.getOperateUserId()));
        return this.ok();
    }

    @ApiOperation(value = "重新实名认证")
    @PutMapping("/reset/authenticate/status")
    public ResponseEntity resetAuthenticateStatus(@RequestBody PlatformResetAuthenticateStatusRequest request, HttpServletRequest httpServletRequest) {
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        this.userRpcProvider.resetAuthenticateStatusByPlatform(request);
        return this.ok();
    }

    @ApiOperation(value = "重置密码")
    @PutMapping("/reset/password")
    public ResponseEntity resetPassword(@RequestBody PlatformResetPasswordRequest request, HttpServletRequest httpServletRequest) {
        request.setIpAddress(IPUtils.getIpAddress(httpServletRequest));
        this.userRpcProvider.resetPasswordByPlatform(request);
        return this.ok();
    }
}
