package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.security.AttendSiteRpcProvider;
import com.bcxin.api.interfaces.security.responses.AttendSiteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 14:05
 */
@RestController
@RequestMapping("/organizations/{organizationId}/attendSite")
public class AttendSiteController extends ControllerAbstract {

    public static Logger logger = LoggerFactory.getLogger(AttendSiteController.class);

    private final AttendSiteRpcProvider attendSiteRpcProvider;


    public AttendSiteController(AttendSiteRpcProvider attendSiteRpcProvider) {
        this.attendSiteRpcProvider = attendSiteRpcProvider;
    }

    /**
     * 负责的驻勤点列表
     * @return
     */
    @GetMapping("/list")
    public ResponseEntity list() {
        List<AttendSiteResponse> data = attendSiteRpcProvider.list(this.getSelectedOrganId());
        return this.ok(data);
    }

}
