package com.bcxin.rest.web.apis.caches;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public class UserOrganBasic implements Serializable {
    private final String organizationId;
    private final String employeeId;
    private final String name;
    private final MasterSlaveType masterSlaveType;
    private final Map<String,Object> additional;
    private final boolean isDomainAdmin;
    private final boolean isDepartAdmin;
    private final String areaCode;

    private final String orgName;

    public UserOrganBasic(String organizationId,
                          String orgName,
                          String employeeId, String name,
                          MasterSlaveType masterSlaveType,
                          Map<String,Object> additional,
                          boolean isDomainAdmin,
                          boolean isDepartAdmin,
                          String areaCode) {
        this.organizationId = organizationId;
        this.orgName = orgName;
        this.employeeId = employeeId;
        this.name = name;
        this.masterSlaveType = masterSlaveType;
        this.additional = additional;
        this.isDomainAdmin = isDomainAdmin;
        this.isDepartAdmin = isDepartAdmin;
        this.areaCode = areaCode;
    }

    public static UserOrganBasic create(String organizationId,
                                        String orgName,
                                        String employeeId, String name,
                                        MasterSlaveType masterSlaveType,Map<String,Object> additional,
                                        boolean isDomainAdmin,
                                        boolean isDepartAdmin,
                                        String areaCode) {
        return new UserOrganBasic(organizationId,orgName, employeeId, name, masterSlaveType, additional, isDomainAdmin,
        isDepartAdmin,
        areaCode);
    }
}
