package com.bcxin.tenant.backend.tasks;

import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.api.interfaces.tenants.OrganizationStatisticsRpcProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 同步组织关系中各组织的统计表
 */
@Component
@ConditionalOnProperty("scheduled.cron.organizationStatisticsSync")
public class OrganizationStatisticsSyncTask extends TaskAbstract{
    private final Logger logger = LoggerFactory.getLogger(OrganizationStatisticsSyncTask.class);
    private OrganizationStatisticsRpcProvider organizationStatisticsRpcProvider;
    private TaskScheduler taskScheduler;

    @Value("${scheduled.cron.organizationStatisticsSync}")
    private String scheduleCron;

    public OrganizationStatisticsSyncTask(OrganizationStatisticsRpcProvider organizationStatisticsRpcProvider, TaskScheduler taskScheduler) {
        this.organizationStatisticsRpcProvider = organizationStatisticsRpcProvider;
        this.taskScheduler = taskScheduler;
    }

    @PostConstruct
    public void init(){
        if(!StringUtils.isEmpty(scheduleCron)){
            taskScheduler.schedule(this::run, new CronTrigger(scheduleCron));
        }
    }


    @Override
    protected void runCore() {
        try{
            organizationStatisticsRpcProvider.syncOrganizationStatistics();
        }catch (Exception e){
            logger.error(String.format("同步组织统计信息时出现异常：%s",e.getMessage()));
        }
    }

    @Override
    public String getTaskName() {
        return "organization.statistics";
    }
}
