package com.bcxin.tenant.backend.tasks;


import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.backend.ScheduleJobConfig;
import com.bcxin.tenant.backend.SharedAppDataSourceConfig;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 员工是否投保同步任务
 *
 * @author ZZD
 * @date 2022/03/30
 */
@Component
public class EmployeeIsSureSyncTask extends TaskAbstract {
    private final CacheProvider cacheProvider;
    private final ScheduleJobConfig scheduleJobConfig;
    private final EmployeeRepository employeeRepository;
    private final DataSource directlySharedAppDataSource;

    public EmployeeIsSureSyncTask(CacheProvider cacheProvider, ScheduleJobConfig scheduleJobConfig, EmployeeRepository employeeRepository, @Qualifier("directlySharedAppDataSource") DataSource directlySharedAppDataSource) {
        this.cacheProvider = cacheProvider;
        this.scheduleJobConfig = scheduleJobConfig;
        this.employeeRepository = employeeRepository;
        this.directlySharedAppDataSource = directlySharedAppDataSource;
    }

    @Override
    protected void runCore() {
        List<String> tlkPerIdIds = null;
        try {
            String iSTrueUserIdSql = "SELECT tlkPerId from per_base_info where idCardNo in (select idCardNo from com_online_ins_per  WHERE createTime > DATE_FORMAT(DATE_SUB(NOW(),INTERVAL 3 DAY),'%Y-%m-%d'));";
            List<Entity> entities = Db.use(directlySharedAppDataSource).query(iSTrueUserIdSql);
            tlkPerIdIds = entities.stream().map(e -> (String) e.get("tlkPerId")).collect(Collectors.toList());
            try {
                Collection<String> notIsSureIds = employeeRepository.queryIdByNotIsSure(tlkPerIdIds);
                employeeRepository.updateIsSureStatus(notIsSureIds, TrueFalseStatus.True);

            } catch (Exception e) {
                logger.error("已投保人员状态变更失败：{}", e.getMessage());
            }
            String iSFalseUserIdSql = "SELECT a.tlkPerId FROM per_org_relation u, per_base_info a, com_ins b WHERE u.perId = a.perId AND u.leaveDate is null AND u.comId=a.comId AND a.comId=b.comId AND a.isIncumbency=1 AND b.updateTime > DATE_FORMAT(DATE_SUB(NOW(),INTERVAL 3 DAY),'%Y-%m-%d') AND NOT EXISTS(SELECT 1 FROM com_online_ins_per WHERE idCardNo=a.idCardNo AND comInsId=b.comInsId);";
            entities = Db.use(directlySharedAppDataSource).query(iSFalseUserIdSql);
            tlkPerIdIds = entities.stream().map(e -> (String) e.get("tlkPerId")).collect(Collectors.toList());
            try {
                Collection<String> successIsSureIds = employeeRepository.queryIdBySuccessIsSure(tlkPerIdIds);
                employeeRepository.updateIsSureStatus(successIsSureIds, TrueFalseStatus.False);
            } catch (Exception e) {
                logger.error("投保失效人员状态变更失效：{}", e.getMessage());
            }

        } catch (Exception e) {
            logger.error("获取未投保的人员失败：{}", e.getMessage());
        }



    }

    @Override
    public String getTaskName() {
        return "employee.data.change";
    }
}
