package com.bcxin.tenant.backend.components.handlers.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.tenant.domain.entities.EventSubscriberEntity;
import com.bcxin.tenant.backend.components.handlers.SubscriberEventActionHandler;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EventSubscribedActionLogRepository;
import com.bcxin.tenant.domain.repositories.EventSubscriberRepository;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import com.bcxin.tenant.domain.utils.ExecuteUtils;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class SmsSubscriberEventActionHandlerImpl implements SubscriberEventActionHandler {
    private final UserRpcProvider userRpcProvider;
    private final TenantDbReader dbReader;
    private final EventSubscribedActionLogRepository eventSubscribedActionLogRepository;
    private final RetryProvider retryProvider;
    private final TenantEventRepository tenantEventRepository;
    private final UnitWork unitWork;
    private final EventSubscriberRepository eventSubscriberRepository;
    private final CacheV2Provider cacheV2Provider;

    private final OrganizationRpcProvider organizationRpcProvider;


    public SmsSubscriberEventActionHandlerImpl(UserRpcProvider userRpcProvider,
                                               TenantDbReader dbReader,
                                               EventSubscribedActionLogRepository eventSubscribedActionLogRepository,
                                               RetryProvider retryProvider, TenantEventRepository tenantEventRepository,
                                               UnitWork unitWork, EventSubscriberRepository eventSubscriberRepository,
                                               CacheV2Provider cacheV2Provider, OrganizationRpcProvider organizationRpcProvider) {
        this.userRpcProvider = userRpcProvider;
        this.dbReader = dbReader;
        this.eventSubscribedActionLogRepository = eventSubscribedActionLogRepository;
        this.retryProvider = retryProvider;
        this.tenantEventRepository = tenantEventRepository;
        this.unitWork = unitWork;
        this.eventSubscriberRepository = eventSubscriberRepository;
        this.cacheV2Provider = cacheV2Provider;
        this.organizationRpcProvider = organizationRpcProvider;
    }

    @Override
    public void execute(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        if("OrganizationEvenForSms".equals(subscriber.getSelector())) {
            Collection<String> mapKeys2 = Stream.of(EventAction.OrganizationEvenForSms.name()).collect(Collectors.toList());
            Collection<TenantEventEntity> tenantEvents2 = this.dbReader.getTopNTenantEvents(subscriber.getLastVersion(), mapKeys2, eventIds, 100);
            if (tenantEvents2.size() == 0) {
                return;
            }

            Collection<String> tenantIds2 =
                    tenantEvents2.stream().map(ii -> ii.getContent()).collect(Collectors.toList());

            tenantIds2.forEach(tenantId2 -> {
                Optional<TenantEventEntity> tenantEventOptional2 = tenantEvents2.stream().filter(ii -> ii.getContent().equals(tenantId2))
                        .findFirst();
                if (tenantEventOptional2.isPresent()) {
                    TenantEventEntity tenantEvent2 = tenantEventOptional2.get();
                    String smsRedisKey2 = String.format("sms_%s_%s", tenantEvent2.getId(), subscriber.getSelector());
                    this.cacheV2Provider.get(smsRedisKey2, () -> {
                        ExecuteUtils.executeTenantEventAction(tenantEvent2, subscriber, () -> {
                            this.organizationRpcProvider.notifyMessage(tenantId2, tenantEvent2.getId());
                        }, retryProvider, eventSubscribedActionLogRepository, eventSubscriberRepository, tenantEventRepository, unitWork);

                        return new Date();
                    }, 60);
                }
            });
        }else{
            Collection<String> mapKeys = Stream.of(EventAction.TenantUserAfterCreatedEventForSms.name()).collect(Collectors.toList());
            Collection<TenantEventEntity> tenantEvents = this.dbReader.getTopNTenantEvents(subscriber.getLastVersion(), mapKeys, eventIds,100);
            if (tenantEvents.size() == 0) {
                return;
            }

            Collection<String> tenantIds =
                    tenantEvents.stream().map(ii -> ii.getContent()).collect(Collectors.toList());

            tenantIds.forEach(tenantId -> {
                Optional<TenantEventEntity> tenantEventOptional = tenantEvents.stream().filter(ii -> ii.getContent().equals(tenantId))
                        .findFirst();
                if (tenantEventOptional.isPresent()) {
                    TenantEventEntity tenantEvent = tenantEventOptional.get();
                    String smsRedisKey = String.format("sms_%s_%s", tenantEvent.getId(), subscriber.getSelector());
                    this.cacheV2Provider.get(smsRedisKey, () -> {
                        ExecuteUtils.executeTenantEventAction(tenantEvent, subscriber, () -> {
                            this.userRpcProvider.notifyMessage(tenantId, tenantEvent.getId());

                        }, retryProvider, eventSubscribedActionLogRepository, eventSubscriberRepository,tenantEventRepository, unitWork);

                        return new Date();
                    }, 60);
                }
            });


        }
    }
}
