/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructure.messages.components;

import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.components.UniqueVerificationCodeGenerator;
import com.bcxin.Infrastructures.components.models.VerificationCode;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueVerificationCodeGeneratorImpl
implements UniqueVerificationCodeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(UniqueVerificationCodeGeneratorImpl.class);
    private final RedissonClient redissonClient;
    private final RetryProvider retryProvider;
    private static final String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public UniqueVerificationCodeGeneratorImpl(RedissonClient redissonClient, RetryProvider retryProvider) {
        this.redissonClient = redissonClient;
        this.retryProvider = retryProvider;
    }

    public VerificationCode execute(String key) {
        AtomicReference gnCode = new AtomicReference();
        AtomicInteger retryIndex = new AtomicInteger(0);
        this.retryProvider.execute(() -> {
            int tryIndex = 0;
            int length = 8;
            do {
                String code;
                if (!this.generateAndStoreUniqueCode(code = UniqueVerificationCodeGeneratorImpl.generateRandomString(length))) continue;
                gnCode.set(code);
                logger.error("\u751f\u6210\u7684\u552f\u4e00\u503c(length={})\u4fe1\u606f:code={};index={}", new Object[]{length, code, tryIndex});
                return;
            } while (retryIndex.incrementAndGet() < 100);
            throw new BadTenantException("\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25, \u8bf7\u91cd\u65b0\u751f\u6210");
        }, 5);
        return VerificationCode.create((String)((String)gnCode.get()), (int)retryIndex.get());
    }

    public boolean generateAndStoreUniqueCode(String code) {
        String luaScript = "local key = KEYS[1]\nlocal code = ARGV[1]\nlocal exists = redis.call('SISMEMBER', key, code)\nif exists == 0 then\n    redis.call('SADD', key, code)\n    redis.call('EXPIRE', key, 28800)\n    return 1\nelse\n    return 0\nend";
        RScript script = this.redissonClient.getScript();
        String key = "unique_vf_codes";
        Object result = script.eval(RScript.Mode.READ_WRITE, luaScript, RScript.ReturnType.BOOLEAN, Collections.singletonList(key), new Object[]{Collections.singletonList(code)});
        return (Boolean)result;
    }

    private static String generateRandomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = (int)(Math.random() * (double)characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }
}

