/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.ThirdSystemValue;
import com.bcxin.tenant.domain.entities.TenantUserThirdCheckStatusEntity;
import com.bcxin.tenant.domain.repositories.TenantUserThirdCheckStatusRepository;
import com.bcxin.tenant.domain.services.TenantUserThirdCheckStatusService;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateCredentialCommand;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantUserThirdCheckStatusServiceImpl
implements TenantUserThirdCheckStatusService {
    private final Logger logger = LoggerFactory.getLogger(TenantUserThirdCheckStatusServiceImpl.class);
    private final UnitWork unitWork;
    private final JsonProvider jsonProvider;
    private final TenantUserThirdCheckStatusRepository tenantUserThirdCheckStatusRepository;

    public TenantUserThirdCheckStatusServiceImpl(UnitWork unitWork, JsonProvider jsonProvider, TenantUserThirdCheckStatusRepository tenantUserThirdCheckStatusRepository) {
        this.unitWork = unitWork;
        this.jsonProvider = jsonProvider;
        this.tenantUserThirdCheckStatusRepository = tenantUserThirdCheckStatusRepository;
    }

    @Override
    public void dispatch(UpdateCredentialCommand command) {
        this.unitWork.executeTran(() -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", command.getId());
            data.put("address", command.getAddress());
            data.put("headPhoto", command.getHeadPhoto());
            data.put("reversePhoto", command.getReversePhoto());
            data.put("frontPhoto", command.getFrontPhoto());
            data.put("validDateFrom", command.getValidDateFrom());
            data.put("validDateTo", command.getValidDateTo());
            TenantUserThirdCheckStatusEntity checkStatusEntity = TenantUserThirdCheckStatusEntity.create(command.getId(), ThirdSystemValue.BKT, this.jsonProvider.getJson(data));
            this.tenantUserThirdCheckStatusRepository.save(checkStatusEntity);
        });
    }
}

