/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.PhoneUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.validations.Credential;
import com.bcxin.Infrastructures.validations.TelephoneValidator;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import java.util.Date;
import javax.persistence.Embedded;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class CreateEmployeeRequestCommand
extends CommandAbstract {
    @NotEmpty
    private final String name;
    @NotEmpty
    private final String telephone;
    @NotEmpty
    private final String departId;
    @NotNull
    private final OccupationType occupationType;
    private final String position;
    @NotNull
    private Date hiredDate;
    @Credential
    private CredentialModel credential;
    private final String organizationId;
    private String areaCode;
    private String password;
    @Embedded
    private final OperatorValueType operator;
    private final AbnormalPersonnelEmployeeType abnormalPersonnelEmployeeType;

    public CreateEmployeeRequestCommand(String organizationId, String name, String telephone, String password, String departId, OccupationType occupationType, String position, Date hiredDate, CredentialType credentialType, String credentialNumber, OperatorValueType operator, AbnormalPersonnelEmployeeType abnormalPersonnelEmployeeType) {
        this.name = name;
        this.telephone = telephone;
        this.departId = departId;
        this.password = password;
        this.occupationType = occupationType;
        this.position = position;
        this.hiredDate = hiredDate;
        this.credential = CredentialModel.create((CredentialType)credentialType, (String)credentialNumber);
        this.organizationId = organizationId;
        this.operator = operator;
        this.abnormalPersonnelEmployeeType = abnormalPersonnelEmployeeType;
    }

    public void validate(boolean isRequiredPhoneAsLoginName, TenantUserConfig tenantUserConfig) {
        super.validate();
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u6240\u5c5e\u4f01\u4e1a\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)this.getDepartId())) {
            throw new ArgumentTenantException("\u6240\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getName())) {
            throw new ArgumentTenantException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getTelephone())) {
            throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!PhoneUtil.isPhone((CharSequence)this.getTelephone()) && !PhoneUtil.isTel((CharSequence)this.getTelephone())) {
            throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.getCredential() == null) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getCredential().getNumber())) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getCredential().getType() == null) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!isRequiredPhoneAsLoginName && this.getOccupationType() != OccupationType.Police && !TelephoneValidator.checkIsValid((String)this.getTelephone())) {
            throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.getOccupationType() == null) {
            throw new ArgumentTenantException("\u804c\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getHiredDate() == null) {
            throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tenantUserConfig != null && tenantUserConfig.isHiredDateMustBeToday() && !DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate((Date)this.getHiredDate()))) {
            throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929");
        }
    }

    public static CreateEmployeeRequestCommand create(String organizationId, String name, String telephone, String password, String departId, OccupationType occupationType, String position, Date hiredTime, CredentialType credentialType, String credentialNumber, OperatorValueType operator, AbnormalPersonnelEmployeeType abnormalPersonnelEmployeeType) {
        return new CreateEmployeeRequestCommand(organizationId, name, telephone, password, departId, occupationType, position, hiredTime, credentialType, credentialNumber, operator, abnormalPersonnelEmployeeType);
    }

    public void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getDepartId() {
        return this.departId;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public String getPosition() {
        return this.position;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public CredentialModel getCredential() {
        return this.credential;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getPassword() {
        return this.password;
    }

    public OperatorValueType getOperator() {
        return this.operator;
    }

    public AbnormalPersonnelEmployeeType getAbnormalPersonnelEmployeeType() {
        return this.abnormalPersonnelEmployeeType;
    }
}

