package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class BatchMoveEmployeesCommand extends CommandAbstract {
    private final String organId;
    private final String destDepartId;
    private final Collection<String> employeeIds;

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getOrganId())) {
            throw new BadTenantException("当前企业信息不能为空!");
        }

        if (!StringUtils.hasLength(this.getDestDepartId())) {
            throw new BadTenantException(String.format("转移的目标部门(%s)不能为空!", this.getDestDepartId()));
        }

        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength(ii))) {
            throw new BadTenantException("要转移的人员列表不能为空!");
        }
    }

    public BatchMoveEmployeesCommand(String organId, Collection<String> employeeIds, String destDepartId) {
        this.organId = organId;
        this.employeeIds = employeeIds;
        this.destDepartId = destDepartId;
    }

    public static BatchMoveEmployeesCommand create(String organId, Collection<String> employeeIds, String destDepartId) {
        return new BatchMoveEmployeesCommand(organId, employeeIds, destDepartId);
    }
}
