package com.bcxin.tenant.domain.readers;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.PersonResourceType;
import com.bcxin.api.interfaces.identities.requests.GetCredentialRequest;
import com.bcxin.api.interfaces.tenants.criterias.ContractCriteria;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeLeaveCriteria;
import com.bcxin.api.interfaces.tenants.criterias.TenantUserRegionCriteria;
import com.bcxin.api.interfaces.tenants.requests.operatelog.SearchOperateLogRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.IMContactCriteria;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.QueryCredentialRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateTenantUserRealNameRequest;
import com.bcxin.api.interfaces.tenants.responses.*;
import com.bcxin.tenant.domain.dto.EmployeeOccupationTypeValidationBasicDto;
import com.bcxin.tenant.domain.dto.EmployeeTenantUserIdNumDto;
import com.bcxin.tenant.domain.dto.TenantUserTelephoneCredentialDto;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.EmployeeExportViewEntity;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialDetailsEntity;
import com.bcxin.tenant.domain.readers.criterias.*;
import com.bcxin.tenant.domain.readers.dtos.OrganizationDto;
import com.bcxin.tenant.domain.readers.dtos.*;
import com.bcxin.tenant.domain.repositories.criterias.ExternalMemberSearchCriteria;
import com.bcxin.tenant.domain.repositories.dtos.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TenantDbReader {
    Pageable<EmployeeDto> find(String organizationId, EmployeeCriteria criteria);

    /**
     * description：获取我管理的部门的所有职员id
     * author：linchunpeng
     * date：2024/4/24
     */
    List<String> getMyDeptEmployeeIdList(Set<String> treeCodes);

    Collection<MyOrganizationProfileDto> getMyOrganizationProfiles(String userId);

    int isAssign(String organId, String tenantUserId);

    Collection<MyImDepartDto> getMyDeparts(String organId, String tenantUserId);

    Collection<MyImContactDto> getMyImContacts(IMContactCriteria request);

    Collection<MyImContactDto> getMyImContactSearch(IMContactCriteria request);

    Pageable<DepartAdminDto> findDepartAdmins(String organizationId, DepartAdminCriteria criteria);

    List<DepartmentAdminExportDto> findExportDepartAdmins(String organizationId, DepartAdminCriteria criteria);

    UserOrganBasicDto getUserOrganBasicDto(String organizationId, String tenantUserId, PersonResourceType resourceType);

    Pageable<EmployeeLeaveDto> findLeaveEmployees(String organizationId, LeaveEmployeeCriteria criteria);

    Pageable<InvitedToJoinQueuesDto> findInvitedToJoinQueuesMember(String organizationId,InvitedToJoinQueuesCriteria criteria);

    Collection<EmployeeBasicDto> getSuperiorEmployeeBasics(String organizationId, Collection<String> ids);

    Collection<EmployeeCompositeDto> getEmployeeComposites(String organizationId, Collection<String> ids);

    Pageable<EmployeeContractDto> findEmployeeContracts(String organizationId, EmployeeContractCriteria criteria);

    Collection<Map<String, EmployeeEntity>> getEmployeesByTelephones(String organizationId, Collection<String> telephones);

    Collection<Map<String, EmployeeEntity>> getEmployeesByIdNums(String organizationId, Collection<String> idNums);

    Collection<String> getMyOrganApps(String organId);

    EmployeeDetailDto getByEmployeeId(String organId, String employeeId);

    Collection<DepartmentDto> getManagedDepartmentDtos(String organId);

    Collection<DepartmentDto> getAllManagedDepartmentDtos(String organId);

    Collection<EmployeeDepartIdDto> getEmployeeDepartIds(String organizationId, Collection<String> employeeIds);

    int checkIfTelephoneExists(String telephone);

    Pageable<OrganizationDto> searchOrganizations(OrganizationCriteria criteria);

    TenantUserCredentialsDto getCertificateByEmployeeId(String employeeId);

    TenantUserDto getTenantUserById(String id);

    TenantUserDto getTenantUserByThirdPartyLoginNo(String id);

    List<CompanyDto> exactSearch(String name, String unifySocialCreditCode);

    Collection<TenantEventEntity> getTopNTenantEvents(Long startVersion, Collection<String> mapKeys, Collection<String> eventIds, int topN);

    Collection<String> getTopNPendingTenantEvents(Collection<String> mapKeys, boolean isForFailed, int topN);

    Collection<EmployeeEntity> getEmployeesByIds(Collection<String> ids);

    List<EmployeeEntity> getEmployeesByUserId(String userId);

    InviteUserDto getByOranIdAndPhone(String organizationId, String phone);

    InviteUserDto getByPhone(String phone);

    InviteUserDto getByOranIdAndIdNum(String organizationId, String idNum);

    InviteUserDto getByIdNum(String idNum);

    Pageable<OrganizationAdminDto> searchOrganAdmins(OrganizationAdminCriteria criteria);

    Collection<String> getDuplicatedEmployeeRelationIds(Collection<String> sourceDepartIds, String destDepartId);

    boolean checkIfNotMatchLeaveCondition(Collection<String> employeeIds);

    List<EmployeeConditionDto> matchLeaveCondition(Collection<String> employeeIds);

    List<EmployeeConditionDto> matchForAttendSite(Collection<String> employeeIds);

//    List<EmployeeConditionDto> matchForAttendSitePerson(Collection<String> employeeIds);

    List<OrganizationExportDto> searchOrgList(com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria criteria);

    List<EmployeeExportViewEntity> searchEmployeeList(String organizationId, EmployeeCriteria criteria);

    List<LeaveEmployeeExportDto> findLeaveEmployeeList(String organizationId, EmployeeLeaveCriteria criteria);

    List<ContractExportDto> findContractList(String organizationId, ContractCriteria criteria);

    EmployeeReportDto findReport(String organizationId, EmployeeCriteria employeeCriteria);

    ContractReportDto findContractReport(String organizationId, ContractCriteria contractCriteria);

    EmployeeBasicDto getEmployeeBasic(String organizationId, String id);

    LoginUserDto getLoginUserByIdNum(String idNum);

    Pageable<CredentialResponse> getCredentials(String id,String organizationId,GetCredentialRequest request);

    List<CurrentCredentialResponse> getCredentials(QueryCredentialRequest queryRequest);

    List<QualificationCredentialResponse> getQualificationCredentials(QueryCredentialRequest request);

    List<TenantUserCredentialDetailsEntity> getQualificationCredential(String idnum);

    List<DepartDto> findDepartAdminsByEmployeeId(String employeeId);

    List<EmployeeEntity> getAllByIdNums(Collection<String> idNums, String areaCode);

    List<EmployeeEntity> getAllByTelephones(Collection<String> telephones, String areaCode);

    List<EmployeeEntity> getSecurityGuardByIdNums(Collection<String> idNums, String areaCode);

    List<UserRegionDto> getUsersByRegion(TenantUserRegionCriteria criteria);

    void updateTenantUserRealNameRequest(List<UpdateTenantUserRealNameRequest> requests);

    Pageable<ImContactDto> contactSearch(IMContactCriteria request);

    Pageable<CompanyCredentialResponse> getCompanys(OrganizationCriteria organizationCriteria);

    UserCredentialDto queryUserCredential(String id, Integer credentialType, String credentialNumber);

    Collection<String> queryCanBeDeletedEventSubscriberLogs(int pageSize);

    EmployeeStatusDto getEmployeeIdByOrganIdAndIdNumAndType(String organId, CredentialType credentialType, String credentialNumber);

    EmployeeStatusDto getEmployeeIdByOrganIdAndTelephone(String organId, String telephone);

    List<BatchEmployeeValidationDto> getOnDutyEmployeeValidationDtoByIdAndAreaCode(String tenantUserId, String areaCode);

    Collection<EmployeeTenantUserIdNumDto> getTenantUserIdMapByIdNums(Collection<String> idNums);

    Collection<EmployeeOccupationTypeValidationBasicDto> getOnDutyEmployeeValidationDtoByIdsAndAreaCode(
            String areaCode, String organizationId, Collection<String> tenantUserIds);

    String getTelephoneByCredentialNumber(CredentialType credentialType, String number);

    Collection<TenantUserTelephoneCredentialDto> getTenantUserTelephoneCredentialsByNumberOrTel(Collection<String> numbers, Collection<String> telephones);

    Pageable<EmployeeRecordDto> searchEmployeeRecords(EmployeeRecordCriteria criteria);

    /**
     * description：判断是否激活分销商
     * author：linchunpeng
     * date：2023/10/31
     */
    boolean isOrganizationPromoter(String organizationId);

    /**
     * description：查询操作日志
     * author：linchunpeng
     * date：2023/12/15
     */
    Pageable<OperateLogResponse> getOperateLogList(SearchOperateLogRequest request, String orgId);

    /**
     * 获取组织管理员姓名和电话基本信息
     */
    Collection<OrganizationAdminiInfoDto> getOrganizationAdminInfo(String organizationId);

    Collection<UserAppealDto> getUserAppeals(UserAppealsCriteria criteria);

    Collection<ExternalMemberDTO> search(ExternalMemberSearchCriteria criteria);

    Collection<MyExternalMemberRecordDTO> getMyExternalMemberRecords(MyExternalMemberRecordCriteria criteria);

    Collection<MyTeamDto> getMyTeamsByUserId(String userId);

    Collection<MyRegistrationOrganizationDto> getMyRegistrationsByUserId(String userId,int pageIndex,int pageSize);
}