package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author huangdunye
 * 2023/5/8 15:18
 */
@Data
@Table(name = "tenant_organization_requests")
@Entity
public class TenantOrganizationRequestsEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(length = 100)
    private String id;
    /**
     * 行业类型
     */
    @Column(name = "industry_code", length = 255)
    private String industryCode;
    /**
     * 机构类型
     */
    @Column(name = "institutional_code", length = 255)
    private String institutionalCode ;
    /**
     * 内网许可审批的请求内容
     */
    @Column(name = "content", length = 2000)
    private String content;
    /**
     * 审批状态
     */
    @Column(name = "status", length = 11)
    private Integer status;
    /**
     * 系统生成的注册编码 created_time
     */
    @Column(name = "number", length = 50)
    private String number;

    /**
     * 创建时间
     */
    @Column(name = "created_time", length = 50)
    private Date createdTime;

    /**
     * 注册成功之后引用tenant_organizations.id
     */
    @Column(name = "referenceId", length = 50)
    private String referenceId;

    @Override
    public String toString() {
        return "TenantOrganizationRequestsEntity{" +
                "id='" + id + '\'' +
                ", industryCode='" + industryCode + '\'' +
                ", institutionalCode='" + institutionalCode + '\'' +
                ", content='" + content + '\'' +
                ", status=" + status +
                ", number='" + number + '\'' +
                ", createdTime=" + createdTime +
                ", referenceId='" + referenceId + '\'' +
                '}';
    }
}
