package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.Date;

/**
 * description：定时删除部门表
 * author：linchunpeng
 * date：2024/12/13
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "tenant_department_scheduled_delete")
@Entity
@Data
public class TenantDepartmentScheduledDeleteEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 部门id
     */
    @Column(name = "department_id")
    private String departmentId;

    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private String organizationId;

    /**
     * 定时删除时间
     */
    @Column(name = "scheduled_delete_time")
    private Date scheduledDeleteTime;

    /**
     * 实际删除时间
     */
    @Column(name = "actual_delete_time")
    private Date actualDeleteTime;

}
