package com.bcxin.tenant.domain.services.commands.xlcp;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;


@Getter
public class CreateXlcpCommand extends CommandAbstract {
    private final String employeeId;
    private final String organizationId;
    private final String serialNumber;
    private final String name;
    private final String number;
    private final String projectName;
    private final String fileUrl;
    private final String suggestion;
    private final String content;
    private final String result;
    private final String resultRuleTip;

    public CreateXlcpCommand(String serialNumber, String name, String number, String employeeId, String organizationId, String projectName, String fileUrl, String suggestion, String content, String result,String resultRuleTip) {
        this.serialNumber = serialNumber;
        this.name = name;
        this.number = number;
        this.employeeId = employeeId;
        this.organizationId = organizationId;
        this.projectName = projectName;
        this.fileUrl = fileUrl;
        this.suggestion = suggestion;
        this.content = content;
        this.result = result;
        this.resultRuleTip = resultRuleTip;
    }

    public static CreateXlcpCommand create(String serialNumber, String name, String number, String employeeId, String organizationId, String projectName, String fileUrl, String suggestion, String content, String result,String resultRuleTip) {
        return new CreateXlcpCommand(serialNumber, name, number, employeeId, organizationId, projectName, fileUrl, suggestion, content, result, resultRuleTip);
    }

    @Override
    public void validate() {
        super.validate();

        if (!StringUtils.hasLength(this.getEmployeeId())) {
            throw new ArgumentTenantException("职员不能为空");
        }

        if (!StringUtils.hasLength(this.getFileUrl())) {
            throw new ArgumentTenantException("报告地址不能为空");
        }

        if (!StringUtils.hasLength(this.getProjectName())) {
            throw new ArgumentTenantException("测评项目不能为空");
        }
        if (!StringUtils.hasLength(this.getSerialNumber())) {
            throw new ArgumentTenantException("业务编号不能为空");
        }

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("企业不能为空");
        }
    }
}
