package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class UpdateUserPhotoCommand extends CommandAbstract {
    private final String id;
    private final String oneInchColorWhitePhoto;
    private final String twoInchColorBluePhoto;

    public UpdateUserPhotoCommand(String id, String oneInchColorWhitePhoto, String twoInchColorBluePhoto) {
        this.id = id;
        this.oneInchColorWhitePhoto = oneInchColorWhitePhoto;
        this.twoInchColorBluePhoto = twoInchColorBluePhoto;
    }

    public static UpdateUserPhotoCommand create(String id, String oneInchColorWhitePhoto, String twoInchColorBluePhoto) {
        return new UpdateUserPhotoCommand(id, oneInchColorWhitePhoto, twoInchColorBluePhoto);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("Id不能为空");
        }
    }
}
