package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class RedoAuthorizationCommand extends CommandAbstract {
    private final String id;

    public RedoAuthorizationCommand(String id) {
        this.id = id;
    }

    public static RedoAuthorizationCommand create(String id) {
        return new RedoAuthorizationCommand(id);
    }

    @Override
    public void validate() {
        if(!StringUtils.hasLength(this.getId())) {
            throw new BadTenantException("当前用户Id不能为空");
        }
    }
}
