package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class UpdateDepartAdminCommand extends CommandAbstract {
    private final String organizationId;
    private final String employeeId;
    private final Collection<String> departIds;

    public UpdateDepartAdminCommand(String organizationId,
                                    String employeeId,
                                    Collection<String> departIds) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.departIds = departIds;
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("操作的企业无效!");
        }

        if (StrUtil.isEmpty(this.getEmployeeId())) {
            throw new ArgumentTenantException("职员信息无效!");
        }

        if (CollectionUtils.isEmpty(this.getDepartIds()) || this.getDepartIds().stream().anyMatch(ii -> !StringUtils.hasLength(ii))) {
            throw new ArgumentTenantException("部门信息无效!");
        }
    }

    public static UpdateDepartAdminCommand create(String organizationId,
                                                  String employeeId,
                                                  Collection<String> departIds) {
        return new UpdateDepartAdminCommand(organizationId, employeeId, departIds);
    }
}
