package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.InvitedStatus;
import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Getter;

@Getter
public class InvitedToJoinQueuesCommand extends CommandAbstract {
    private final String name;
    private final String telephone;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final InvitedType invitedType;
    private final String departmentId;
    private final String inviteId;
    private final OccupationType occupationType;
    private final InvitedStatus invitedStatus;
    private final String lastOperatorId;
    private final String lastOperatorName;

    public InvitedToJoinQueuesCommand(String name,
                                      String telephone,
                                      CredentialType credentialType,
                                      String credentialNumber,
                                      InvitedType invitedType,
                                      String departmentId,
                                      String inviteId,
                                      OccupationType occupationType,
                                      InvitedStatus invitedStatus,
                                      String lastOperatorId,
                                      String lastOperatorName) {
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.invitedType = invitedType;
        this.departmentId = departmentId;
        this.inviteId = inviteId;
        this.occupationType = occupationType;
        this.invitedStatus = invitedStatus;
        this.lastOperatorId = lastOperatorId;
        this.lastOperatorName = lastOperatorName;
    }

    public static InvitedToJoinQueuesCommand create(String name,
                                                    String telephone,
                                                    CredentialType credentialType,
                                                    String credentialNumber,
                                                    InvitedType invitedType,
                                                    String departmentId,
                                                    String inviteId,
                                                    OccupationType occupationType,
                                                    InvitedStatus invitedStatus,
                                                    String lastOperatorId,
                                                    String lastOperatorName) {
        return new InvitedToJoinQueuesCommand(name,telephone,credentialType,credentialNumber,
                invitedType,departmentId,inviteId,occupationType,invitedStatus,
                lastOperatorId,lastOperatorName);
    }
}
