package com.bcxin.tenant.domain.entities.valueTypes;

import com.bcxin.Infrastructures.entities.ValueType;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Embeddable;

@Setter(AccessLevel.PROTECTED)
@Getter
@Embeddable
public class ItemValueType extends ValueType {
    /**
     * 编码
     */
    @Column(length = 50,name = "code")
    private String code;

    /**
     * 名称
     */
    @Column(length = 200,name = "name")
    private String name;

    protected ItemValueType(){}

    public static ItemValueType create(String code, String name) {
        ItemValueType itemValueType = new ItemValueType();
        itemValueType.setCode(code);
        itemValueType.setName(name);

        return itemValueType;
    }
}
