package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.Date;

/**
 * description：平台操作日志表
 * author：linchunpeng
 * date：2024/11/12
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "t_platform_operate_log")
@Entity
@Data
public class PlatformOperateLogEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 用户id
     */
    @Column(name = "tenant_user_id")
    private String tenantUserId;

    /**
     * 职员id
     */
    @Column(name = "employee_id")
    private String employeeId;

    /**
     * 姓名
     */
    @Column(name = "real_name")
    private String realName;

    /**
     * 操作类型：1修改用户姓名，2重新实名认证，3企业审批通过，4企业审批不通过，5重置密码
     */
    @Column(name = "operate_type")
    private Integer operateType;

    /**
     * 被操作的用户id
     */
    @Column(name = "operate_user_id")
    private String operateUserId;

    /**
     * 操作时间
     */
    @Column(name = "operate_time")
    private Date operateTime;

    /**
     * 操作内容
     */
    @Column(name = "operate_content")
    private String operateContent;

    /**
     * 操作原因
     */
    @Column(name = "operate_reason")
    private String operateReason;

    /**
     * IP地址
     */
    @Column(name = "ip_address")
    private String ipAddress;

}
