package com.bcxin.tenant.domain.entities;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_organization_admins")
@Entity
public class OrganizationAdminEntity extends OpEntityAbstract implements IAggregate {
    @Id
    @Column(name = "id", length = 255)
    private String id;

    @ManyToOne(cascade = CascadeType.DETACH)
    @JoinColumn(name = "organization_id", referencedColumnName = "id", foreignKey = @ForeignKey(name = "fk_organization_admin_organization_id", value = ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;

    @ManyToOne(cascade = CascadeType.DETACH)
    @JoinColumn(name = "employee_id", referencedColumnName = "id", foreignKey = @ForeignKey(name = "fk_organization_admin_employee_id", value = ConstraintMode.CONSTRAINT))
    private EmployeeEntity employee;

    protected OrganizationAdminEntity() {
    }

    protected OrganizationAdminEntity(OrganizationEntity organization, EmployeeEntity employee) {
        this.setId(UUIDUtil.getShortUuid());

        this.setOrganization(organization);
        this.setEmployee(employee);
    }

    public static OrganizationAdminEntity create(OrganizationEntity organization, EmployeeEntity employee) {
        return new OrganizationAdminEntity(organization, employee);
    }
}
