package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * 邀请入职部门
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_invite_depart")
@Entity
public class InviteDepartEntity extends EntityAbstract implements IAggregate {

    /**
     * 区域ID
     */
    @Id
    private String id;

    /**
     * 所属公司
     */
    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "organization_id", referencedColumnName = "id", nullable = false,
            foreignKey = @ForeignKey(name = "fk_tenant_invite_depart_organization_id", value = ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;

    /**
     * 入职部门
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "depart_id", referencedColumnName = "id",
            foreignKey = @ForeignKey(name = "fk_tenant_invite_depart_id", value = ConstraintMode.CONSTRAINT))
    private DepartmentEntity department;

    /**
     * 职业类型: 保安员, 其他
     */
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "occupation_type", nullable = false)
    private OccupationType occupationType;

    /**
     * 链接有效截止日期
     */
    @Column(name = "end_time", nullable = false)
    private Timestamp endTime;

    @Column(name = "area_code", nullable = true)
    private String areaCode;

    /**
     * 操作人
     */
    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name = "id",
                    column = @Column(name = "creator_id", nullable = true, length = 150)),
            @AttributeOverride(name = "name",
                    column = @Column(name = "creator_name", nullable = true, length = 200)),
            @AttributeOverride(name = "createdTime",
                    column = @Column(name = "created_time", nullable = true))
    })
    private OperatorValueType creator;

    public InviteDepartEntity() {}

    public static InviteDepartEntity create(OrganizationEntity organization, DepartmentEntity department, OccupationType occupationType, Timestamp endTime,
                                            String areaCode,
                                            OperatorValueType creator) {
        InviteDepartEntity inviteDepartEntity = new InviteDepartEntity();
        inviteDepartEntity.setOrganization(organization);
        inviteDepartEntity.setDepartment(department);
        inviteDepartEntity.setOccupationType(occupationType);
        inviteDepartEntity.setEndTime(endTime);
        inviteDepartEntity.setId(UUIDUtil.getShortUuid());
        inviteDepartEntity.setAreaCode(areaCode);
        inviteDepartEntity.setCreator(creator);
        return inviteDepartEntity;
    }

}






