package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "queue_imported_data_items")
public class ImportDataItemEntity extends EntityAbstract {
    @Id
    private String id;

    @Column(name = "data", length = 4000, nullable = false)
    private String data;

    @Column(name = "result", length = 4000)
    private String result;


    @Column(name = "last_processed_time",nullable = true)
    private Timestamp lastProcessedTime;

    @Column(name = "created_time",nullable = false)
    private Timestamp createdTime;

    @Column(name = "status",nullable = false)
    @Enumerated(EnumType.ORDINAL)
    private ProcessedStatus status;

    @ManyToOne()
    @JoinColumn(name = "imported_data_id",referencedColumnName = "id")
    private ImportDataEntity importData;


    public void changeStatus(ProcessedStatus status,String result) {
        this.setStatus(status);
        this.setResult(result);
        this.setLastProcessedTime(Timestamp.from(Instant.now()));
    }

    protected ImportDataItemEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ImportDataItemEntity create(ImportDataEntity importData,
                                              String data) {
        ImportDataItemEntity dataItemEntity = new ImportDataItemEntity();
        dataItemEntity.setId(UUID.randomUUID().toString());
        dataItemEntity.setImportData(importData);
        dataItemEntity.setData(data);
        dataItemEntity.setStatus(ProcessedStatus.Init);

        return dataItemEntity;
    }
}
