/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.commons.responses;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.CompanyCertificateType;
import com.bcxin.Infrastructures.enums.CompanyNature;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EconomicType;
import com.bcxin.Infrastructures.enums.IndustryDetailType;
import com.bcxin.Infrastructures.enums.ParentSubsidiary;
import com.bcxin.Infrastructures.enums.SecurityArmedRating;
import com.bcxin.Infrastructures.enums.SecurityPreparednessRating;
import com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating;
import com.bcxin.Infrastructures.snapshots.OrgGisLocationSnapshot;
import com.bcxin.Infrastructures.utils.GeoLocationValueType;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="\u4f01\u4e1a\u6ce8\u518c\u4fe1\u606f\u8fd4\u56de\u5bf9\u8c61")
public class CompanyResponse
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CompanyResponse.class);
    @ApiModelProperty(value="ID")
    private String id;
    @ApiModelProperty(value="\u884c\u4e1a\u7c7b\u578b")
    private String industryCode;
    @ApiModelProperty(value="\u673a\u6784\u7c7b\u578b")
    private String institutionalCode;
    @ApiModelProperty(value="\u884c\u4e1a\u540d\u79f0")
    private String industryName;
    @ApiModelProperty(value="\u673a\u6784\u540d\u79f0")
    private String institutionalName;
    @ApiModelProperty(value="\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.IndustryDetailType")
    private Integer industryDetailType;
    @ApiModelProperty(value="\u516c\u53f8\u540d\u79f0")
    private String name;
    @ApiModelProperty(value="\u603b/\u5206/\u5b50\u516c\u53f8", notes="com.bcxin.Infrastructures.enums.ParentSubsidiary")
    private Integer type;
    @ApiModelProperty(value="\u8054\u7cfb\u7535\u8bdd")
    private String telephone;
    @ApiModelProperty(value="\u7ecf\u6d4e\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.EconomicType")
    private Integer economicType;
    @ApiModelProperty(value="\u516c\u53f8\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CompanyNature")
    private Integer nature;
    @ApiModelProperty(value="\u6ce8\u518c\u5730\u533a")
    private LocationRequest placeOfRegister;
    @ApiModelProperty(value="\u7ecf\u8425\u5730\u533a")
    private LocationRequest placeOfBusiness;
    @ApiModelProperty(value="\u603b\u516c\u53f8\u540d\u79f0")
    private String parentName;
    @ApiModelProperty(value="\u603b\u516c\u53f8\u8bc1\u4ef6\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private Integer parentCertificateType;
    @ApiModelProperty(value="\u603b\u516c\u53f8\u8bc1\u4ef6\u53f7\u7801")
    private String parentCertificateNumber;
    @ApiModelProperty(value="\u603b\u516c\u53f8\u6cd5\u4eba\u59d3\u540d")
    private String parentLegalPersonName;
    @ApiModelProperty(value="\u603b\u516c\u53f8\u8054\u7cfb\u7535\u8bdd")
    private String parentLegalPersonTelephone;
    @ApiModelProperty(value="\u6cd5\u4eba\u59d3\u540d")
    private String legalPersonName;
    @ApiModelProperty(value="\u6cd5\u4eba\u624b\u673a\u53f7\u7801")
    private String legalPersonTelephone;
    @ApiModelProperty(value="\u6cd5\u4eba\u8bc1\u4ef6\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private Integer legalPersonCredentialType;
    @ApiModelProperty(value="\u6cd5\u4eba\u8bc1\u4ef6\u53f7\u7801")
    private String legalPersonCredentialNumber;
    @ApiModelProperty(value="\u6cd5\u4eba\u56fd\u7c4d")
    private String legalPersonNationality;
    @ApiModelProperty(value="\u4fdd\u5b89\u8d1f\u8d23\u4eba\u59d3\u540d")
    private String securityPersonName;
    @ApiModelProperty(value="\u4fdd\u5b89\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u7801")
    private String securityPersonTelephone;
    @ApiModelProperty(value="\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private Integer securityPersonCredentialType;
    @ApiModelProperty(value="\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u53f7\u7801")
    private String securityPersonCredentialNumber;
    @ApiModelProperty(value="\u6ce8\u518c\u8d44\u672c\uff08\u4e07\u5143\uff09")
    private String registeredCapital;
    @ApiModelProperty(value="\u56fa\u5b9a\u8d44\u4ea7\uff08\u4e07\u5143\uff09")
    private String fixedCapital;
    @ApiModelProperty(value="\u5e74\u8425\u4e1a\u989d\uff08\u4e07\u5143\uff09")
    private String annualSalesVolume;
    @ApiModelProperty(value="\u5e74\u5229\u7a0e\uff08\u4e07\u5143\uff09")
    private String annualProfitTax;
    @ApiModelProperty(value="\u8bc1\u4ef6\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private Integer certificateType;
    @ApiModelProperty(value="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801")
    private String unifySocialCreditCode;
    @ApiModelProperty(value="\u8425\u4e1a\u6267\u7167\u626b\u63cf\u4ef6")
    private String unifySocialCreditCodeFile;
    @ApiModelProperty(value="\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef/\u4fdd\u5b89\u57f9\u8bad\u5907\u6848\u8bc1\u53f7")
    private String servicePermitNumber;
    @ApiModelProperty(value="\u53d1\u8bc1\u673a\u5173\u540d\u79f0")
    private String nameOfIssuingAuthority;
    @ApiModelProperty(value="\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u9996\u6b21\u53d1\u8bc1\u65e5\u671f\u6216\u8005\u57f9\u8bad\u5355\u4f4d\u7684\u53d1\u8bc1\u65e5\u671f")
    private Date firstIssueServicePermit;
    @ApiModelProperty(value="\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u626b\u63cf\u4ef6\u6216\u8005\u4fdd\u5b89\u57f9\u8bad\u8bb8\u53ef\uff08\u5907\u6848\uff09\u8bc1\u626b\u63cf\u4ef6")
    private String servicePermitAttachment;
    @ApiModelProperty(value="\u6279\u51c6\u6587\u53f7")
    private String securityApprovalNumber;
    @ApiModelProperty(value="\u670d\u52a1\u8303\u56f4\uff09")
    private List<String> serviceScopeList;
    @ApiModelProperty(value="\u4eba\u529b\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7", notes="com.bcxin.Infrastructures.enums.SecurityPreparednessRating")
    private Integer securityPreparednessRating;
    @ApiModelProperty(value="\u6b66\u88c5\u5b88\u62a4\u62bc\u8fd0\u8bc4\u5b9a\u7b49\u7ea7", notes="com.bcxin.Infrastructures.enums.SecurityArmedRating")
    private Integer securityArmedRating;
    @ApiModelProperty(value="\u5b89\u5168\u6280\u672f\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7", notes="com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating")
    private Integer securitySafetyDefenseRating;
    @ApiModelProperty(value="\u662f\u5426\u6709\u98ce\u9669\u8bc4\u4f30\u8d44\u8d28")
    private Boolean isRiskAssessment;
    @ApiModelProperty(value="\u57f9\u8bad\u5355\u4f4d\u7684\u57f9\u8bad\u5185\u5bb9")
    private String trainContent;
    @ApiModelProperty(value="\u62df\u81ea\u62db\u4fdd\u5b89\u5458\u6570")
    private Integer numberOfSecurityGuards;
    @ApiModelProperty(value="\u662f\u5426\u6cbb\u5b89\u4fdd\u536b\u91cd\u70b9\u5355\u4f4d")
    private Boolean isPublicSecuritySecurity;
    @ApiModelProperty(value="\u662f\u5426\u7269\u4e1a\u4f01\u4e1a")
    private Boolean isPropertyEnterprise;
    @ApiModelProperty(value="\u81ea\u62db\u4fdd\u5b89\u5355\u4f4d\u6027\u8d28")
    private String natureOfSelfRecruitedUnits;
    @ApiModelProperty(value="\u76d1\u7ba1\u5730\u533a")
    private LocationRequest placeOfSupervise;
    @ApiModelProperty(value="\u76d1\u7ba1\u673a\u6784")
    private String superviseDepartId;
    @ApiModelProperty(value="\u76d1\u7ba1\u673a\u6784\u540d\u79f0")
    private String superviseDepartName;
    @ApiModelProperty(value="\u5206\u4eab\u5355\u4f4d\u540d\u79f0")
    private String shareOrganizationName;
    @ApiModelProperty(value="\u5206\u4eab\u804c\u5458\u59d3\u540d")
    private String shareEmployeeName;
    @ApiModelProperty(value="\u7cfb\u7edf\u7ba1\u7406\u5458")
    private ContactRequest administrator;
    @ApiModelProperty(value="\u7ecf\u5ea6")
    private Double longitude;
    @ApiModelProperty(value="\u7eac\u5ea6")
    private Double latitude;
    @ApiModelProperty(value="\u662f\u5426\u5f3a\u63d0\u9192\u7ecf\u7eac\u5ea6\u4fe1\u606f")
    private boolean IsValidLonlat;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u66f4\u6539\u7ecf\u7eac\u5ea6")
    private boolean IsAllowedChangeLonlat;
    @ApiModelProperty(value="\u7ecf\u7eac\u5ea6\u6700\u5927\u5141\u8bb8\u4fee\u6539\u6b21\u6570")
    private int allowedMonthGisChangesCount;
    @ApiModelProperty(value="\u7ecf\u7eac\u5ea6\u5269\u4f59\u4fee\u6539\u6b21\u6570")
    private int alreadyChangedCount;
    @ApiModelProperty(value="\u7ecf\u7eac\u5ea6\u5730\u5740")
    private String locationAddress;

    public CompanyResponse() {
    }

    public CompanyResponse(String id, String industryCode, String institutionalCode, String industryName, String institutionalName, IndustryDetailType industryDetailType, String name, ParentSubsidiary type, String telephone, EconomicType economicType, CompanyNature nature, LocationRequest placeOfRegister, LocationRequest placeOfBusiness, String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber, String parentLegalPersonName, String parentLegalPersonTelephone, String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType, String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone, CredentialType securityPersonCredentialType, String securityPersonCredentialNumber, String registeredCapital, String fixedCapital, String annualSalesVolume, String annualProfitTax, CompanyCertificateType certificateType, String unifySocialCreditCode, String unifySocialCreditCodeFile, String servicePermitNumber, String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment, String securityApprovalNumber, List<String> serviceScopeList, SecurityPreparednessRating securityPreparednessRating, SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating, Boolean isRiskAssessment, String trainContent, Integer numberOfSecurityGuards, Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits, String superviseRegionCode, String superviseDepartId, String superviseDepartName, String shareOrganizationName, String shareEmployeeName, ContactRequest administrator, Double longitude, Double latitude, String lonLatJson, JsonProvider jsonProvider, int allowedMonthGisChanges) {
        this.id = id;
        this.industryName = industryName;
        this.institutionalName = institutionalName;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.industryDetailType = industryDetailType == null ? null : Integer.valueOf(industryDetailType.ordinal());
        this.name = name;
        this.type = type == null ? null : Integer.valueOf(type.ordinal());
        this.telephone = telephone;
        this.economicType = economicType == null ? null : Integer.valueOf(economicType.ordinal());
        this.nature = nature == null ? null : Integer.valueOf(nature.ordinal());
        this.placeOfRegister = placeOfRegister == null ? LocationRequest.createEmpty() : placeOfRegister;
        this.placeOfBusiness = placeOfBusiness == null ? LocationRequest.createEmpty() : placeOfBusiness;
        this.parentName = parentName;
        this.parentCertificateType = parentCertificateType == null ? null : Integer.valueOf(parentCertificateType.ordinal());
        this.parentCertificateNumber = parentCertificateNumber;
        this.parentLegalPersonName = parentLegalPersonName;
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
        this.legalPersonName = legalPersonName;
        this.legalPersonTelephone = legalPersonTelephone;
        this.legalPersonCredentialType = legalPersonCredentialType == null ? null : Integer.valueOf(legalPersonCredentialType.ordinal());
        this.legalPersonCredentialNumber = legalPersonCredentialNumber;
        this.legalPersonNationality = legalPersonNationality;
        this.securityPersonName = securityPersonName;
        this.securityPersonTelephone = securityPersonTelephone;
        this.securityPersonCredentialType = securityPersonCredentialType == null ? null : Integer.valueOf(securityPersonCredentialType.ordinal());
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
        this.registeredCapital = registeredCapital;
        this.fixedCapital = fixedCapital;
        this.annualSalesVolume = annualSalesVolume;
        this.annualProfitTax = annualProfitTax;
        this.certificateType = certificateType == null ? null : Integer.valueOf(certificateType.ordinal());
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.servicePermitNumber = servicePermitNumber;
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
        this.firstIssueServicePermit = firstIssueServicePermit;
        this.servicePermitAttachment = servicePermitAttachment;
        this.securityApprovalNumber = securityApprovalNumber;
        this.serviceScopeList = serviceScopeList;
        this.securityPreparednessRating = securityPreparednessRating == null ? null : Integer.valueOf(securityPreparednessRating.ordinal());
        this.securityArmedRating = securityArmedRating == null ? null : Integer.valueOf(securityArmedRating.ordinal());
        this.securitySafetyDefenseRating = securitySafetyDefenseRating == null ? null : Integer.valueOf(securitySafetyDefenseRating.ordinal());
        this.isRiskAssessment = isRiskAssessment;
        this.trainContent = trainContent;
        this.numberOfSecurityGuards = numberOfSecurityGuards;
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
        this.isPropertyEnterprise = isPropertyEnterprise;
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.shareOrganizationName = shareOrganizationName;
        this.shareEmployeeName = shareEmployeeName;
        this.administrator = administrator;
        this.longitude = longitude;
        this.latitude = latitude;
        if (this.getPlaceOfSupervise() == null) {
            this.setPlaceOfSupervise(new LocationRequest());
        }
        if (this.getPlaceOfSupervise().getProvince() == null) {
            this.getPlaceOfSupervise().setProvince(new LocationRequest.ItemValueRequest());
        }
        if (this.getPlaceOfSupervise().getCity() == null) {
            this.getPlaceOfSupervise().setCity(new LocationRequest.ItemValueRequest());
        }
        if (this.getPlaceOfSupervise().getDistrict() == null) {
            this.getPlaceOfSupervise().setDistrict(new LocationRequest.ItemValueRequest());
        }
        if (StringUtils.isNotBlank((CharSequence)superviseRegionCode) && superviseRegionCode.length() == 6) {
            this.getPlaceOfSupervise().getProvince().setCode(superviseRegionCode.substring(0, 2).concat("0000"));
            this.getPlaceOfSupervise().getCity().setCode(superviseRegionCode.substring(0, 4).concat("00"));
            this.getPlaceOfSupervise().getDistrict().setCode(superviseRegionCode);
        }
        if (this.latitude == null || this.longitude == null) {
            this.IsValidLonlat = true;
        }
        this.IsValidLonlat = !GeoLocationValueType.isValidLocation((Double)this.latitude, (Double)this.longitude);
        try {
            OrgGisLocationSnapshot sn = (OrgGisLocationSnapshot)jsonProvider.toObject(OrgGisLocationSnapshot.class, lonLatJson);
            this.allowedMonthGisChangesCount = allowedMonthGisChanges;
            if (sn != null) {
                this.locationAddress = sn.getAddress();
                int count = allowedMonthGisChanges - sn.getCount();
                this.alreadyChangedCount = count <= 0 ? 0 : count;
            } else {
                this.alreadyChangedCount = allowedMonthGisChanges;
            }
            if (this.IsValidLonlat) {
                this.IsAllowedChangeLonlat = true;
            } else if (sn != null) {
                LocalDate localDate2;
                LocalDate localDate = sn.getTime().toLocalDateTime().toLocalDate();
                long days = ChronoUnit.DAYS.between(localDate, localDate2 = Timestamp.from(Instant.now()).toLocalDateTime().toLocalDate());
                if (days <= 30L) {
                    this.IsAllowedChangeLonlat = sn.getCount() < allowedMonthGisChanges;
                } else {
                    this.IsAllowedChangeLonlat = true;
                    this.alreadyChangedCount = allowedMonthGisChanges;
                }
            } else {
                this.IsAllowedChangeLonlat = true;
            }
        }
        catch (Exception ex) {
            logger.error("\u65e0\u6548\u6570\u636e{}\u95ee\u9898", (Object)lonLatJson, (Object)ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public String getIndustryName() {
        return this.industryName;
    }

    public String getInstitutionalName() {
        return this.institutionalName;
    }

    public Integer getIndustryDetailType() {
        return this.industryDetailType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public Integer getEconomicType() {
        return this.economicType;
    }

    public Integer getNature() {
        return this.nature;
    }

    public LocationRequest getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public LocationRequest getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Integer getParentCertificateType() {
        return this.parentCertificateType;
    }

    public String getParentCertificateNumber() {
        return this.parentCertificateNumber;
    }

    public String getParentLegalPersonName() {
        return this.parentLegalPersonName;
    }

    public String getParentLegalPersonTelephone() {
        return this.parentLegalPersonTelephone;
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public String getLegalPersonTelephone() {
        return this.legalPersonTelephone;
    }

    public Integer getLegalPersonCredentialType() {
        return this.legalPersonCredentialType;
    }

    public String getLegalPersonCredentialNumber() {
        return this.legalPersonCredentialNumber;
    }

    public String getLegalPersonNationality() {
        return this.legalPersonNationality;
    }

    public String getSecurityPersonName() {
        return this.securityPersonName;
    }

    public String getSecurityPersonTelephone() {
        return this.securityPersonTelephone;
    }

    public Integer getSecurityPersonCredentialType() {
        return this.securityPersonCredentialType;
    }

    public String getSecurityPersonCredentialNumber() {
        return this.securityPersonCredentialNumber;
    }

    public String getRegisteredCapital() {
        return this.registeredCapital;
    }

    public String getFixedCapital() {
        return this.fixedCapital;
    }

    public String getAnnualSalesVolume() {
        return this.annualSalesVolume;
    }

    public String getAnnualProfitTax() {
        return this.annualProfitTax;
    }

    public Integer getCertificateType() {
        return this.certificateType;
    }

    public String getUnifySocialCreditCode() {
        return this.unifySocialCreditCode;
    }

    public String getUnifySocialCreditCodeFile() {
        return this.unifySocialCreditCodeFile;
    }

    public String getServicePermitNumber() {
        return this.servicePermitNumber;
    }

    public String getNameOfIssuingAuthority() {
        return this.nameOfIssuingAuthority;
    }

    public Date getFirstIssueServicePermit() {
        return this.firstIssueServicePermit;
    }

    public String getServicePermitAttachment() {
        return this.servicePermitAttachment;
    }

    public String getSecurityApprovalNumber() {
        return this.securityApprovalNumber;
    }

    public List<String> getServiceScopeList() {
        return this.serviceScopeList;
    }

    public Integer getSecurityPreparednessRating() {
        return this.securityPreparednessRating;
    }

    public Integer getSecurityArmedRating() {
        return this.securityArmedRating;
    }

    public Integer getSecuritySafetyDefenseRating() {
        return this.securitySafetyDefenseRating;
    }

    public Boolean getIsRiskAssessment() {
        return this.isRiskAssessment;
    }

    public String getTrainContent() {
        return this.trainContent;
    }

    public Integer getNumberOfSecurityGuards() {
        return this.numberOfSecurityGuards;
    }

    public Boolean getIsPublicSecuritySecurity() {
        return this.isPublicSecuritySecurity;
    }

    public Boolean getIsPropertyEnterprise() {
        return this.isPropertyEnterprise;
    }

    public String getNatureOfSelfRecruitedUnits() {
        return this.natureOfSelfRecruitedUnits;
    }

    public LocationRequest getPlaceOfSupervise() {
        return this.placeOfSupervise;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getShareOrganizationName() {
        return this.shareOrganizationName;
    }

    public String getShareEmployeeName() {
        return this.shareEmployeeName;
    }

    public ContactRequest getAdministrator() {
        return this.administrator;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public boolean isIsValidLonlat() {
        return this.IsValidLonlat;
    }

    public boolean isIsAllowedChangeLonlat() {
        return this.IsAllowedChangeLonlat;
    }

    public int getAllowedMonthGisChangesCount() {
        return this.allowedMonthGisChangesCount;
    }

    public int getAlreadyChangedCount() {
        return this.alreadyChangedCount;
    }

    public String getLocationAddress() {
        return this.locationAddress;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public void setInstitutionalCode(String institutionalCode) {
        this.institutionalCode = institutionalCode;
    }

    public void setIndustryName(String industryName) {
        this.industryName = industryName;
    }

    public void setInstitutionalName(String institutionalName) {
        this.institutionalName = institutionalName;
    }

    public void setIndustryDetailType(Integer industryDetailType) {
        this.industryDetailType = industryDetailType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setEconomicType(Integer economicType) {
        this.economicType = economicType;
    }

    public void setNature(Integer nature) {
        this.nature = nature;
    }

    public void setPlaceOfRegister(LocationRequest placeOfRegister) {
        this.placeOfRegister = placeOfRegister;
    }

    public void setPlaceOfBusiness(LocationRequest placeOfBusiness) {
        this.placeOfBusiness = placeOfBusiness;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setParentCertificateType(Integer parentCertificateType) {
        this.parentCertificateType = parentCertificateType;
    }

    public void setParentCertificateNumber(String parentCertificateNumber) {
        this.parentCertificateNumber = parentCertificateNumber;
    }

    public void setParentLegalPersonName(String parentLegalPersonName) {
        this.parentLegalPersonName = parentLegalPersonName;
    }

    public void setParentLegalPersonTelephone(String parentLegalPersonTelephone) {
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public void setLegalPersonTelephone(String legalPersonTelephone) {
        this.legalPersonTelephone = legalPersonTelephone;
    }

    public void setLegalPersonCredentialType(Integer legalPersonCredentialType) {
        this.legalPersonCredentialType = legalPersonCredentialType;
    }

    public void setLegalPersonCredentialNumber(String legalPersonCredentialNumber) {
        this.legalPersonCredentialNumber = legalPersonCredentialNumber;
    }

    public void setLegalPersonNationality(String legalPersonNationality) {
        this.legalPersonNationality = legalPersonNationality;
    }

    public void setSecurityPersonName(String securityPersonName) {
        this.securityPersonName = securityPersonName;
    }

    public void setSecurityPersonTelephone(String securityPersonTelephone) {
        this.securityPersonTelephone = securityPersonTelephone;
    }

    public void setSecurityPersonCredentialType(Integer securityPersonCredentialType) {
        this.securityPersonCredentialType = securityPersonCredentialType;
    }

    public void setSecurityPersonCredentialNumber(String securityPersonCredentialNumber) {
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
    }

    public void setRegisteredCapital(String registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public void setFixedCapital(String fixedCapital) {
        this.fixedCapital = fixedCapital;
    }

    public void setAnnualSalesVolume(String annualSalesVolume) {
        this.annualSalesVolume = annualSalesVolume;
    }

    public void setAnnualProfitTax(String annualProfitTax) {
        this.annualProfitTax = annualProfitTax;
    }

    public void setCertificateType(Integer certificateType) {
        this.certificateType = certificateType;
    }

    public void setUnifySocialCreditCode(String unifySocialCreditCode) {
        this.unifySocialCreditCode = unifySocialCreditCode;
    }

    public void setUnifySocialCreditCodeFile(String unifySocialCreditCodeFile) {
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
    }

    public void setServicePermitNumber(String servicePermitNumber) {
        this.servicePermitNumber = servicePermitNumber;
    }

    public void setNameOfIssuingAuthority(String nameOfIssuingAuthority) {
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
    }

    public void setFirstIssueServicePermit(Date firstIssueServicePermit) {
        this.firstIssueServicePermit = firstIssueServicePermit;
    }

    public void setServicePermitAttachment(String servicePermitAttachment) {
        this.servicePermitAttachment = servicePermitAttachment;
    }

    public void setSecurityApprovalNumber(String securityApprovalNumber) {
        this.securityApprovalNumber = securityApprovalNumber;
    }

    public void setServiceScopeList(List<String> serviceScopeList) {
        this.serviceScopeList = serviceScopeList;
    }

    public void setSecurityPreparednessRating(Integer securityPreparednessRating) {
        this.securityPreparednessRating = securityPreparednessRating;
    }

    public void setSecurityArmedRating(Integer securityArmedRating) {
        this.securityArmedRating = securityArmedRating;
    }

    public void setSecuritySafetyDefenseRating(Integer securitySafetyDefenseRating) {
        this.securitySafetyDefenseRating = securitySafetyDefenseRating;
    }

    public void setIsRiskAssessment(Boolean isRiskAssessment) {
        this.isRiskAssessment = isRiskAssessment;
    }

    public void setTrainContent(String trainContent) {
        this.trainContent = trainContent;
    }

    public void setNumberOfSecurityGuards(Integer numberOfSecurityGuards) {
        this.numberOfSecurityGuards = numberOfSecurityGuards;
    }

    public void setIsPublicSecuritySecurity(Boolean isPublicSecuritySecurity) {
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
    }

    public void setIsPropertyEnterprise(Boolean isPropertyEnterprise) {
        this.isPropertyEnterprise = isPropertyEnterprise;
    }

    public void setNatureOfSelfRecruitedUnits(String natureOfSelfRecruitedUnits) {
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
    }

    public void setPlaceOfSupervise(LocationRequest placeOfSupervise) {
        this.placeOfSupervise = placeOfSupervise;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setShareOrganizationName(String shareOrganizationName) {
        this.shareOrganizationName = shareOrganizationName;
    }

    public void setShareEmployeeName(String shareEmployeeName) {
        this.shareEmployeeName = shareEmployeeName;
    }

    public void setAdministrator(ContactRequest administrator) {
        this.administrator = administrator;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setIsValidLonlat(boolean IsValidLonlat) {
        this.IsValidLonlat = IsValidLonlat;
    }

    public void setIsAllowedChangeLonlat(boolean IsAllowedChangeLonlat) {
        this.IsAllowedChangeLonlat = IsAllowedChangeLonlat;
    }

    public void setAllowedMonthGisChangesCount(int allowedMonthGisChangesCount) {
        this.allowedMonthGisChangesCount = allowedMonthGisChangesCount;
    }

    public void setAlreadyChangedCount(int alreadyChangedCount) {
        this.alreadyChangedCount = alreadyChangedCount;
    }

    public void setLocationAddress(String locationAddress) {
        this.locationAddress = locationAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompanyResponse)) {
            return false;
        }
        CompanyResponse other = (CompanyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIsValidLonlat() != other.isIsValidLonlat()) {
            return false;
        }
        if (this.isIsAllowedChangeLonlat() != other.isIsAllowedChangeLonlat()) {
            return false;
        }
        if (this.getAllowedMonthGisChangesCount() != other.getAllowedMonthGisChangesCount()) {
            return false;
        }
        if (this.getAlreadyChangedCount() != other.getAlreadyChangedCount()) {
            return false;
        }
        Integer this$industryDetailType = this.getIndustryDetailType();
        Integer other$industryDetailType = other.getIndustryDetailType();
        if (this$industryDetailType == null ? other$industryDetailType != null : !((Object)this$industryDetailType).equals(other$industryDetailType)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$economicType = this.getEconomicType();
        Integer other$economicType = other.getEconomicType();
        if (this$economicType == null ? other$economicType != null : !((Object)this$economicType).equals(other$economicType)) {
            return false;
        }
        Integer this$nature = this.getNature();
        Integer other$nature = other.getNature();
        if (this$nature == null ? other$nature != null : !((Object)this$nature).equals(other$nature)) {
            return false;
        }
        Integer this$parentCertificateType = this.getParentCertificateType();
        Integer other$parentCertificateType = other.getParentCertificateType();
        if (this$parentCertificateType == null ? other$parentCertificateType != null : !((Object)this$parentCertificateType).equals(other$parentCertificateType)) {
            return false;
        }
        Integer this$legalPersonCredentialType = this.getLegalPersonCredentialType();
        Integer other$legalPersonCredentialType = other.getLegalPersonCredentialType();
        if (this$legalPersonCredentialType == null ? other$legalPersonCredentialType != null : !((Object)this$legalPersonCredentialType).equals(other$legalPersonCredentialType)) {
            return false;
        }
        Integer this$securityPersonCredentialType = this.getSecurityPersonCredentialType();
        Integer other$securityPersonCredentialType = other.getSecurityPersonCredentialType();
        if (this$securityPersonCredentialType == null ? other$securityPersonCredentialType != null : !((Object)this$securityPersonCredentialType).equals(other$securityPersonCredentialType)) {
            return false;
        }
        Integer this$certificateType = this.getCertificateType();
        Integer other$certificateType = other.getCertificateType();
        if (this$certificateType == null ? other$certificateType != null : !((Object)this$certificateType).equals(other$certificateType)) {
            return false;
        }
        Integer this$securityPreparednessRating = this.getSecurityPreparednessRating();
        Integer other$securityPreparednessRating = other.getSecurityPreparednessRating();
        if (this$securityPreparednessRating == null ? other$securityPreparednessRating != null : !((Object)this$securityPreparednessRating).equals(other$securityPreparednessRating)) {
            return false;
        }
        Integer this$securityArmedRating = this.getSecurityArmedRating();
        Integer other$securityArmedRating = other.getSecurityArmedRating();
        if (this$securityArmedRating == null ? other$securityArmedRating != null : !((Object)this$securityArmedRating).equals(other$securityArmedRating)) {
            return false;
        }
        Integer this$securitySafetyDefenseRating = this.getSecuritySafetyDefenseRating();
        Integer other$securitySafetyDefenseRating = other.getSecuritySafetyDefenseRating();
        if (this$securitySafetyDefenseRating == null ? other$securitySafetyDefenseRating != null : !((Object)this$securitySafetyDefenseRating).equals(other$securitySafetyDefenseRating)) {
            return false;
        }
        Boolean this$isRiskAssessment = this.getIsRiskAssessment();
        Boolean other$isRiskAssessment = other.getIsRiskAssessment();
        if (this$isRiskAssessment == null ? other$isRiskAssessment != null : !((Object)this$isRiskAssessment).equals(other$isRiskAssessment)) {
            return false;
        }
        Integer this$numberOfSecurityGuards = this.getNumberOfSecurityGuards();
        Integer other$numberOfSecurityGuards = other.getNumberOfSecurityGuards();
        if (this$numberOfSecurityGuards == null ? other$numberOfSecurityGuards != null : !((Object)this$numberOfSecurityGuards).equals(other$numberOfSecurityGuards)) {
            return false;
        }
        Boolean this$isPublicSecuritySecurity = this.getIsPublicSecuritySecurity();
        Boolean other$isPublicSecuritySecurity = other.getIsPublicSecuritySecurity();
        if (this$isPublicSecuritySecurity == null ? other$isPublicSecuritySecurity != null : !((Object)this$isPublicSecuritySecurity).equals(other$isPublicSecuritySecurity)) {
            return false;
        }
        Boolean this$isPropertyEnterprise = this.getIsPropertyEnterprise();
        Boolean other$isPropertyEnterprise = other.getIsPropertyEnterprise();
        if (this$isPropertyEnterprise == null ? other$isPropertyEnterprise != null : !((Object)this$isPropertyEnterprise).equals(other$isPropertyEnterprise)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$industryCode = this.getIndustryCode();
        String other$industryCode = other.getIndustryCode();
        if (this$industryCode == null ? other$industryCode != null : !this$industryCode.equals(other$industryCode)) {
            return false;
        }
        String this$institutionalCode = this.getInstitutionalCode();
        String other$institutionalCode = other.getInstitutionalCode();
        if (this$institutionalCode == null ? other$institutionalCode != null : !this$institutionalCode.equals(other$institutionalCode)) {
            return false;
        }
        String this$industryName = this.getIndustryName();
        String other$industryName = other.getIndustryName();
        if (this$industryName == null ? other$industryName != null : !this$industryName.equals(other$industryName)) {
            return false;
        }
        String this$institutionalName = this.getInstitutionalName();
        String other$institutionalName = other.getInstitutionalName();
        if (this$institutionalName == null ? other$institutionalName != null : !this$institutionalName.equals(other$institutionalName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$telephone = this.getTelephone();
        String other$telephone = other.getTelephone();
        if (this$telephone == null ? other$telephone != null : !this$telephone.equals(other$telephone)) {
            return false;
        }
        LocationRequest this$placeOfRegister = this.getPlaceOfRegister();
        LocationRequest other$placeOfRegister = other.getPlaceOfRegister();
        if (this$placeOfRegister == null ? other$placeOfRegister != null : !((Object)this$placeOfRegister).equals(other$placeOfRegister)) {
            return false;
        }
        LocationRequest this$placeOfBusiness = this.getPlaceOfBusiness();
        LocationRequest other$placeOfBusiness = other.getPlaceOfBusiness();
        if (this$placeOfBusiness == null ? other$placeOfBusiness != null : !((Object)this$placeOfBusiness).equals(other$placeOfBusiness)) {
            return false;
        }
        String this$parentName = this.getParentName();
        String other$parentName = other.getParentName();
        if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
            return false;
        }
        String this$parentCertificateNumber = this.getParentCertificateNumber();
        String other$parentCertificateNumber = other.getParentCertificateNumber();
        if (this$parentCertificateNumber == null ? other$parentCertificateNumber != null : !this$parentCertificateNumber.equals(other$parentCertificateNumber)) {
            return false;
        }
        String this$parentLegalPersonName = this.getParentLegalPersonName();
        String other$parentLegalPersonName = other.getParentLegalPersonName();
        if (this$parentLegalPersonName == null ? other$parentLegalPersonName != null : !this$parentLegalPersonName.equals(other$parentLegalPersonName)) {
            return false;
        }
        String this$parentLegalPersonTelephone = this.getParentLegalPersonTelephone();
        String other$parentLegalPersonTelephone = other.getParentLegalPersonTelephone();
        if (this$parentLegalPersonTelephone == null ? other$parentLegalPersonTelephone != null : !this$parentLegalPersonTelephone.equals(other$parentLegalPersonTelephone)) {
            return false;
        }
        String this$legalPersonName = this.getLegalPersonName();
        String other$legalPersonName = other.getLegalPersonName();
        if (this$legalPersonName == null ? other$legalPersonName != null : !this$legalPersonName.equals(other$legalPersonName)) {
            return false;
        }
        String this$legalPersonTelephone = this.getLegalPersonTelephone();
        String other$legalPersonTelephone = other.getLegalPersonTelephone();
        if (this$legalPersonTelephone == null ? other$legalPersonTelephone != null : !this$legalPersonTelephone.equals(other$legalPersonTelephone)) {
            return false;
        }
        String this$legalPersonCredentialNumber = this.getLegalPersonCredentialNumber();
        String other$legalPersonCredentialNumber = other.getLegalPersonCredentialNumber();
        if (this$legalPersonCredentialNumber == null ? other$legalPersonCredentialNumber != null : !this$legalPersonCredentialNumber.equals(other$legalPersonCredentialNumber)) {
            return false;
        }
        String this$legalPersonNationality = this.getLegalPersonNationality();
        String other$legalPersonNationality = other.getLegalPersonNationality();
        if (this$legalPersonNationality == null ? other$legalPersonNationality != null : !this$legalPersonNationality.equals(other$legalPersonNationality)) {
            return false;
        }
        String this$securityPersonName = this.getSecurityPersonName();
        String other$securityPersonName = other.getSecurityPersonName();
        if (this$securityPersonName == null ? other$securityPersonName != null : !this$securityPersonName.equals(other$securityPersonName)) {
            return false;
        }
        String this$securityPersonTelephone = this.getSecurityPersonTelephone();
        String other$securityPersonTelephone = other.getSecurityPersonTelephone();
        if (this$securityPersonTelephone == null ? other$securityPersonTelephone != null : !this$securityPersonTelephone.equals(other$securityPersonTelephone)) {
            return false;
        }
        String this$securityPersonCredentialNumber = this.getSecurityPersonCredentialNumber();
        String other$securityPersonCredentialNumber = other.getSecurityPersonCredentialNumber();
        if (this$securityPersonCredentialNumber == null ? other$securityPersonCredentialNumber != null : !this$securityPersonCredentialNumber.equals(other$securityPersonCredentialNumber)) {
            return false;
        }
        String this$registeredCapital = this.getRegisteredCapital();
        String other$registeredCapital = other.getRegisteredCapital();
        if (this$registeredCapital == null ? other$registeredCapital != null : !this$registeredCapital.equals(other$registeredCapital)) {
            return false;
        }
        String this$fixedCapital = this.getFixedCapital();
        String other$fixedCapital = other.getFixedCapital();
        if (this$fixedCapital == null ? other$fixedCapital != null : !this$fixedCapital.equals(other$fixedCapital)) {
            return false;
        }
        String this$annualSalesVolume = this.getAnnualSalesVolume();
        String other$annualSalesVolume = other.getAnnualSalesVolume();
        if (this$annualSalesVolume == null ? other$annualSalesVolume != null : !this$annualSalesVolume.equals(other$annualSalesVolume)) {
            return false;
        }
        String this$annualProfitTax = this.getAnnualProfitTax();
        String other$annualProfitTax = other.getAnnualProfitTax();
        if (this$annualProfitTax == null ? other$annualProfitTax != null : !this$annualProfitTax.equals(other$annualProfitTax)) {
            return false;
        }
        String this$unifySocialCreditCode = this.getUnifySocialCreditCode();
        String other$unifySocialCreditCode = other.getUnifySocialCreditCode();
        if (this$unifySocialCreditCode == null ? other$unifySocialCreditCode != null : !this$unifySocialCreditCode.equals(other$unifySocialCreditCode)) {
            return false;
        }
        String this$unifySocialCreditCodeFile = this.getUnifySocialCreditCodeFile();
        String other$unifySocialCreditCodeFile = other.getUnifySocialCreditCodeFile();
        if (this$unifySocialCreditCodeFile == null ? other$unifySocialCreditCodeFile != null : !this$unifySocialCreditCodeFile.equals(other$unifySocialCreditCodeFile)) {
            return false;
        }
        String this$servicePermitNumber = this.getServicePermitNumber();
        String other$servicePermitNumber = other.getServicePermitNumber();
        if (this$servicePermitNumber == null ? other$servicePermitNumber != null : !this$servicePermitNumber.equals(other$servicePermitNumber)) {
            return false;
        }
        String this$nameOfIssuingAuthority = this.getNameOfIssuingAuthority();
        String other$nameOfIssuingAuthority = other.getNameOfIssuingAuthority();
        if (this$nameOfIssuingAuthority == null ? other$nameOfIssuingAuthority != null : !this$nameOfIssuingAuthority.equals(other$nameOfIssuingAuthority)) {
            return false;
        }
        Date this$firstIssueServicePermit = this.getFirstIssueServicePermit();
        Date other$firstIssueServicePermit = other.getFirstIssueServicePermit();
        if (this$firstIssueServicePermit == null ? other$firstIssueServicePermit != null : !((Object)this$firstIssueServicePermit).equals(other$firstIssueServicePermit)) {
            return false;
        }
        String this$servicePermitAttachment = this.getServicePermitAttachment();
        String other$servicePermitAttachment = other.getServicePermitAttachment();
        if (this$servicePermitAttachment == null ? other$servicePermitAttachment != null : !this$servicePermitAttachment.equals(other$servicePermitAttachment)) {
            return false;
        }
        String this$securityApprovalNumber = this.getSecurityApprovalNumber();
        String other$securityApprovalNumber = other.getSecurityApprovalNumber();
        if (this$securityApprovalNumber == null ? other$securityApprovalNumber != null : !this$securityApprovalNumber.equals(other$securityApprovalNumber)) {
            return false;
        }
        List<String> this$serviceScopeList = this.getServiceScopeList();
        List<String> other$serviceScopeList = other.getServiceScopeList();
        if (this$serviceScopeList == null ? other$serviceScopeList != null : !((Object)this$serviceScopeList).equals(other$serviceScopeList)) {
            return false;
        }
        String this$trainContent = this.getTrainContent();
        String other$trainContent = other.getTrainContent();
        if (this$trainContent == null ? other$trainContent != null : !this$trainContent.equals(other$trainContent)) {
            return false;
        }
        String this$natureOfSelfRecruitedUnits = this.getNatureOfSelfRecruitedUnits();
        String other$natureOfSelfRecruitedUnits = other.getNatureOfSelfRecruitedUnits();
        if (this$natureOfSelfRecruitedUnits == null ? other$natureOfSelfRecruitedUnits != null : !this$natureOfSelfRecruitedUnits.equals(other$natureOfSelfRecruitedUnits)) {
            return false;
        }
        LocationRequest this$placeOfSupervise = this.getPlaceOfSupervise();
        LocationRequest other$placeOfSupervise = other.getPlaceOfSupervise();
        if (this$placeOfSupervise == null ? other$placeOfSupervise != null : !((Object)this$placeOfSupervise).equals(other$placeOfSupervise)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$shareOrganizationName = this.getShareOrganizationName();
        String other$shareOrganizationName = other.getShareOrganizationName();
        if (this$shareOrganizationName == null ? other$shareOrganizationName != null : !this$shareOrganizationName.equals(other$shareOrganizationName)) {
            return false;
        }
        String this$shareEmployeeName = this.getShareEmployeeName();
        String other$shareEmployeeName = other.getShareEmployeeName();
        if (this$shareEmployeeName == null ? other$shareEmployeeName != null : !this$shareEmployeeName.equals(other$shareEmployeeName)) {
            return false;
        }
        ContactRequest this$administrator = this.getAdministrator();
        ContactRequest other$administrator = other.getAdministrator();
        if (this$administrator == null ? other$administrator != null : !((Object)this$administrator).equals(other$administrator)) {
            return false;
        }
        String this$locationAddress = this.getLocationAddress();
        String other$locationAddress = other.getLocationAddress();
        return !(this$locationAddress == null ? other$locationAddress != null : !this$locationAddress.equals(other$locationAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompanyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIsValidLonlat() ? 79 : 97);
        result = result * 59 + (this.isIsAllowedChangeLonlat() ? 79 : 97);
        result = result * 59 + this.getAllowedMonthGisChangesCount();
        result = result * 59 + this.getAlreadyChangedCount();
        Integer $industryDetailType = this.getIndustryDetailType();
        result = result * 59 + ($industryDetailType == null ? 43 : ((Object)$industryDetailType).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $economicType = this.getEconomicType();
        result = result * 59 + ($economicType == null ? 43 : ((Object)$economicType).hashCode());
        Integer $nature = this.getNature();
        result = result * 59 + ($nature == null ? 43 : ((Object)$nature).hashCode());
        Integer $parentCertificateType = this.getParentCertificateType();
        result = result * 59 + ($parentCertificateType == null ? 43 : ((Object)$parentCertificateType).hashCode());
        Integer $legalPersonCredentialType = this.getLegalPersonCredentialType();
        result = result * 59 + ($legalPersonCredentialType == null ? 43 : ((Object)$legalPersonCredentialType).hashCode());
        Integer $securityPersonCredentialType = this.getSecurityPersonCredentialType();
        result = result * 59 + ($securityPersonCredentialType == null ? 43 : ((Object)$securityPersonCredentialType).hashCode());
        Integer $certificateType = this.getCertificateType();
        result = result * 59 + ($certificateType == null ? 43 : ((Object)$certificateType).hashCode());
        Integer $securityPreparednessRating = this.getSecurityPreparednessRating();
        result = result * 59 + ($securityPreparednessRating == null ? 43 : ((Object)$securityPreparednessRating).hashCode());
        Integer $securityArmedRating = this.getSecurityArmedRating();
        result = result * 59 + ($securityArmedRating == null ? 43 : ((Object)$securityArmedRating).hashCode());
        Integer $securitySafetyDefenseRating = this.getSecuritySafetyDefenseRating();
        result = result * 59 + ($securitySafetyDefenseRating == null ? 43 : ((Object)$securitySafetyDefenseRating).hashCode());
        Boolean $isRiskAssessment = this.getIsRiskAssessment();
        result = result * 59 + ($isRiskAssessment == null ? 43 : ((Object)$isRiskAssessment).hashCode());
        Integer $numberOfSecurityGuards = this.getNumberOfSecurityGuards();
        result = result * 59 + ($numberOfSecurityGuards == null ? 43 : ((Object)$numberOfSecurityGuards).hashCode());
        Boolean $isPublicSecuritySecurity = this.getIsPublicSecuritySecurity();
        result = result * 59 + ($isPublicSecuritySecurity == null ? 43 : ((Object)$isPublicSecuritySecurity).hashCode());
        Boolean $isPropertyEnterprise = this.getIsPropertyEnterprise();
        result = result * 59 + ($isPropertyEnterprise == null ? 43 : ((Object)$isPropertyEnterprise).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $industryCode = this.getIndustryCode();
        result = result * 59 + ($industryCode == null ? 43 : $industryCode.hashCode());
        String $institutionalCode = this.getInstitutionalCode();
        result = result * 59 + ($institutionalCode == null ? 43 : $institutionalCode.hashCode());
        String $industryName = this.getIndustryName();
        result = result * 59 + ($industryName == null ? 43 : $industryName.hashCode());
        String $institutionalName = this.getInstitutionalName();
        result = result * 59 + ($institutionalName == null ? 43 : $institutionalName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $telephone = this.getTelephone();
        result = result * 59 + ($telephone == null ? 43 : $telephone.hashCode());
        LocationRequest $placeOfRegister = this.getPlaceOfRegister();
        result = result * 59 + ($placeOfRegister == null ? 43 : ((Object)$placeOfRegister).hashCode());
        LocationRequest $placeOfBusiness = this.getPlaceOfBusiness();
        result = result * 59 + ($placeOfBusiness == null ? 43 : ((Object)$placeOfBusiness).hashCode());
        String $parentName = this.getParentName();
        result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
        String $parentCertificateNumber = this.getParentCertificateNumber();
        result = result * 59 + ($parentCertificateNumber == null ? 43 : $parentCertificateNumber.hashCode());
        String $parentLegalPersonName = this.getParentLegalPersonName();
        result = result * 59 + ($parentLegalPersonName == null ? 43 : $parentLegalPersonName.hashCode());
        String $parentLegalPersonTelephone = this.getParentLegalPersonTelephone();
        result = result * 59 + ($parentLegalPersonTelephone == null ? 43 : $parentLegalPersonTelephone.hashCode());
        String $legalPersonName = this.getLegalPersonName();
        result = result * 59 + ($legalPersonName == null ? 43 : $legalPersonName.hashCode());
        String $legalPersonTelephone = this.getLegalPersonTelephone();
        result = result * 59 + ($legalPersonTelephone == null ? 43 : $legalPersonTelephone.hashCode());
        String $legalPersonCredentialNumber = this.getLegalPersonCredentialNumber();
        result = result * 59 + ($legalPersonCredentialNumber == null ? 43 : $legalPersonCredentialNumber.hashCode());
        String $legalPersonNationality = this.getLegalPersonNationality();
        result = result * 59 + ($legalPersonNationality == null ? 43 : $legalPersonNationality.hashCode());
        String $securityPersonName = this.getSecurityPersonName();
        result = result * 59 + ($securityPersonName == null ? 43 : $securityPersonName.hashCode());
        String $securityPersonTelephone = this.getSecurityPersonTelephone();
        result = result * 59 + ($securityPersonTelephone == null ? 43 : $securityPersonTelephone.hashCode());
        String $securityPersonCredentialNumber = this.getSecurityPersonCredentialNumber();
        result = result * 59 + ($securityPersonCredentialNumber == null ? 43 : $securityPersonCredentialNumber.hashCode());
        String $registeredCapital = this.getRegisteredCapital();
        result = result * 59 + ($registeredCapital == null ? 43 : $registeredCapital.hashCode());
        String $fixedCapital = this.getFixedCapital();
        result = result * 59 + ($fixedCapital == null ? 43 : $fixedCapital.hashCode());
        String $annualSalesVolume = this.getAnnualSalesVolume();
        result = result * 59 + ($annualSalesVolume == null ? 43 : $annualSalesVolume.hashCode());
        String $annualProfitTax = this.getAnnualProfitTax();
        result = result * 59 + ($annualProfitTax == null ? 43 : $annualProfitTax.hashCode());
        String $unifySocialCreditCode = this.getUnifySocialCreditCode();
        result = result * 59 + ($unifySocialCreditCode == null ? 43 : $unifySocialCreditCode.hashCode());
        String $unifySocialCreditCodeFile = this.getUnifySocialCreditCodeFile();
        result = result * 59 + ($unifySocialCreditCodeFile == null ? 43 : $unifySocialCreditCodeFile.hashCode());
        String $servicePermitNumber = this.getServicePermitNumber();
        result = result * 59 + ($servicePermitNumber == null ? 43 : $servicePermitNumber.hashCode());
        String $nameOfIssuingAuthority = this.getNameOfIssuingAuthority();
        result = result * 59 + ($nameOfIssuingAuthority == null ? 43 : $nameOfIssuingAuthority.hashCode());
        Date $firstIssueServicePermit = this.getFirstIssueServicePermit();
        result = result * 59 + ($firstIssueServicePermit == null ? 43 : ((Object)$firstIssueServicePermit).hashCode());
        String $servicePermitAttachment = this.getServicePermitAttachment();
        result = result * 59 + ($servicePermitAttachment == null ? 43 : $servicePermitAttachment.hashCode());
        String $securityApprovalNumber = this.getSecurityApprovalNumber();
        result = result * 59 + ($securityApprovalNumber == null ? 43 : $securityApprovalNumber.hashCode());
        List<String> $serviceScopeList = this.getServiceScopeList();
        result = result * 59 + ($serviceScopeList == null ? 43 : ((Object)$serviceScopeList).hashCode());
        String $trainContent = this.getTrainContent();
        result = result * 59 + ($trainContent == null ? 43 : $trainContent.hashCode());
        String $natureOfSelfRecruitedUnits = this.getNatureOfSelfRecruitedUnits();
        result = result * 59 + ($natureOfSelfRecruitedUnits == null ? 43 : $natureOfSelfRecruitedUnits.hashCode());
        LocationRequest $placeOfSupervise = this.getPlaceOfSupervise();
        result = result * 59 + ($placeOfSupervise == null ? 43 : ((Object)$placeOfSupervise).hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $shareOrganizationName = this.getShareOrganizationName();
        result = result * 59 + ($shareOrganizationName == null ? 43 : $shareOrganizationName.hashCode());
        String $shareEmployeeName = this.getShareEmployeeName();
        result = result * 59 + ($shareEmployeeName == null ? 43 : $shareEmployeeName.hashCode());
        ContactRequest $administrator = this.getAdministrator();
        result = result * 59 + ($administrator == null ? 43 : ((Object)$administrator).hashCode());
        String $locationAddress = this.getLocationAddress();
        result = result * 59 + ($locationAddress == null ? 43 : $locationAddress.hashCode());
        return result;
    }

    public String toString() {
        return "CompanyResponse(id=" + this.getId() + ", industryCode=" + this.getIndustryCode() + ", institutionalCode=" + this.getInstitutionalCode() + ", industryName=" + this.getIndustryName() + ", institutionalName=" + this.getInstitutionalName() + ", industryDetailType=" + this.getIndustryDetailType() + ", name=" + this.getName() + ", type=" + this.getType() + ", telephone=" + this.getTelephone() + ", economicType=" + this.getEconomicType() + ", nature=" + this.getNature() + ", placeOfRegister=" + this.getPlaceOfRegister() + ", placeOfBusiness=" + this.getPlaceOfBusiness() + ", parentName=" + this.getParentName() + ", parentCertificateType=" + this.getParentCertificateType() + ", parentCertificateNumber=" + this.getParentCertificateNumber() + ", parentLegalPersonName=" + this.getParentLegalPersonName() + ", parentLegalPersonTelephone=" + this.getParentLegalPersonTelephone() + ", legalPersonName=" + this.getLegalPersonName() + ", legalPersonTelephone=" + this.getLegalPersonTelephone() + ", legalPersonCredentialType=" + this.getLegalPersonCredentialType() + ", legalPersonCredentialNumber=" + this.getLegalPersonCredentialNumber() + ", legalPersonNationality=" + this.getLegalPersonNationality() + ", securityPersonName=" + this.getSecurityPersonName() + ", securityPersonTelephone=" + this.getSecurityPersonTelephone() + ", securityPersonCredentialType=" + this.getSecurityPersonCredentialType() + ", securityPersonCredentialNumber=" + this.getSecurityPersonCredentialNumber() + ", registeredCapital=" + this.getRegisteredCapital() + ", fixedCapital=" + this.getFixedCapital() + ", annualSalesVolume=" + this.getAnnualSalesVolume() + ", annualProfitTax=" + this.getAnnualProfitTax() + ", certificateType=" + this.getCertificateType() + ", unifySocialCreditCode=" + this.getUnifySocialCreditCode() + ", unifySocialCreditCodeFile=" + this.getUnifySocialCreditCodeFile() + ", servicePermitNumber=" + this.getServicePermitNumber() + ", nameOfIssuingAuthority=" + this.getNameOfIssuingAuthority() + ", firstIssueServicePermit=" + this.getFirstIssueServicePermit() + ", servicePermitAttachment=" + this.getServicePermitAttachment() + ", securityApprovalNumber=" + this.getSecurityApprovalNumber() + ", serviceScopeList=" + this.getServiceScopeList() + ", securityPreparednessRating=" + this.getSecurityPreparednessRating() + ", securityArmedRating=" + this.getSecurityArmedRating() + ", securitySafetyDefenseRating=" + this.getSecuritySafetyDefenseRating() + ", isRiskAssessment=" + this.getIsRiskAssessment() + ", trainContent=" + this.getTrainContent() + ", numberOfSecurityGuards=" + this.getNumberOfSecurityGuards() + ", isPublicSecuritySecurity=" + this.getIsPublicSecuritySecurity() + ", isPropertyEnterprise=" + this.getIsPropertyEnterprise() + ", natureOfSelfRecruitedUnits=" + this.getNatureOfSelfRecruitedUnits() + ", placeOfSupervise=" + this.getPlaceOfSupervise() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", shareOrganizationName=" + this.getShareOrganizationName() + ", shareEmployeeName=" + this.getShareEmployeeName() + ", administrator=" + this.getAdministrator() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", IsValidLonlat=" + this.isIsValidLonlat() + ", IsAllowedChangeLonlat=" + this.isIsAllowedChangeLonlat() + ", allowedMonthGisChangesCount=" + this.getAllowedMonthGisChangesCount() + ", alreadyChangedCount=" + this.getAlreadyChangedCount() + ", locationAddress=" + this.getLocationAddress() + ")";
    }

    @ApiModel(value="\u4f01\u4e1a\u4eba\u5458\u4fe1\u606f")
    public static class ContactRequest
    implements Serializable {
        @ApiModelProperty(value="\u59d3\u540d")
        private String name;
        @ApiModelProperty(value="\u624b\u673a\u53f7\u7801")
        private String telephone;
        @ApiModelProperty(value="\u8bc1\u4ef6\u7c7b\u578b", notes="com.bcxin.Infrastructures.enums.CredentialType")
        private Integer credentialType;
        @ApiModelProperty(value="\u8bc1\u4ef6\u53f7\u7801")
        private String credentialNumber;
        @ApiModelProperty(value="\u56fd\u7c4d")
        private String nationality;

        public ContactRequest() {
        }

        public ContactRequest(String name, String telephone, Integer credentialType, String credentialNumber, String nationality) {
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
            this.nationality = nationality;
        }

        public String getName() {
            return this.name;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public Integer getCredentialType() {
            return this.credentialType;
        }

        public String getCredentialNumber() {
            return this.credentialNumber;
        }

        public String getNationality() {
            return this.nationality;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        public void setCredentialType(Integer credentialType) {
            this.credentialType = credentialType;
        }

        public void setCredentialNumber(String credentialNumber) {
            this.credentialNumber = credentialNumber;
        }

        public void setNationality(String nationality) {
            this.nationality = nationality;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContactRequest)) {
                return false;
            }
            ContactRequest other = (ContactRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$credentialType = this.getCredentialType();
            Integer other$credentialType = other.getCredentialType();
            if (this$credentialType == null ? other$credentialType != null : !((Object)this$credentialType).equals(other$credentialType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$telephone = this.getTelephone();
            String other$telephone = other.getTelephone();
            if (this$telephone == null ? other$telephone != null : !this$telephone.equals(other$telephone)) {
                return false;
            }
            String this$credentialNumber = this.getCredentialNumber();
            String other$credentialNumber = other.getCredentialNumber();
            if (this$credentialNumber == null ? other$credentialNumber != null : !this$credentialNumber.equals(other$credentialNumber)) {
                return false;
            }
            String this$nationality = this.getNationality();
            String other$nationality = other.getNationality();
            return !(this$nationality == null ? other$nationality != null : !this$nationality.equals(other$nationality));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContactRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $credentialType = this.getCredentialType();
            result = result * 59 + ($credentialType == null ? 43 : ((Object)$credentialType).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $telephone = this.getTelephone();
            result = result * 59 + ($telephone == null ? 43 : $telephone.hashCode());
            String $credentialNumber = this.getCredentialNumber();
            result = result * 59 + ($credentialNumber == null ? 43 : $credentialNumber.hashCode());
            String $nationality = this.getNationality();
            result = result * 59 + ($nationality == null ? 43 : $nationality.hashCode());
            return result;
        }

        public String toString() {
            return "CompanyResponse.ContactRequest(name=" + this.getName() + ", telephone=" + this.getTelephone() + ", credentialType=" + this.getCredentialType() + ", credentialNumber=" + this.getCredentialNumber() + ", nationality=" + this.getNationality() + ")";
        }
    }
}

