package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import javax.persistence.Column;
import javax.persistence.Id;
import java.sql.Timestamp;
@ApiModel("集团组织类型详情")
@Getter
public class OrganizationTypeResponse extends ResponseAbstract {


    @ApiModelProperty(value = "id")
    private final long id;

    @ApiModelProperty(value = "名称")
    private final String name;

    @ApiModelProperty(value = "备注")
    private final String note;

    @ApiModelProperty(value = "组织Id")
    private final String organizationId;

    @ApiModelProperty(value = "创建时间")
    private final Timestamp createTime;

    @ApiModelProperty(value = "创建人Id")
    private final String creatorId;

    @ApiModelProperty(value = "最后更新人Id")
    private final String lastUpdateId;

    @ApiModelProperty(value = "最后更新时间")
    private final Timestamp lastUpdateTime;

    public OrganizationTypeResponse(long id, String name, String note, String organizationId, Timestamp createTime, String creatorId, String lastUpdateId, Timestamp lastUpdateTime) {
        this.id = id;
        this.name = name;
        this.note = note;
        this.organizationId = organizationId;
        this.createTime = createTime;
        this.creatorId = creatorId;
        this.lastUpdateId = lastUpdateId;
        this.lastUpdateTime = lastUpdateTime;
    }

    public static OrganizationTypeResponse create(long id, String name, String note, String organizationId, Timestamp createTime, String creatorId, String lastUpdateId, Timestamp lastUpdateTime) {
        return new OrganizationTypeResponse(id, name, note, organizationId, createTime, creatorId, lastUpdateId, lastUpdateTime);
    }

}
