package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@ApiModel(value = "组织管理员基本信息")
@Getter
public class OrganizationAdminResponse extends ResponseAbstract {
    @ApiModelProperty(value = "职员id")
    private final String id;
    @ApiModelProperty(value = "姓名")
    private final String name;
    @ApiModelProperty(value = "电话")
    private final String telephone;
    @ApiModelProperty(value = "部门名称")
    private final String departName;

    public OrganizationAdminResponse(String id, String name, String telephone, String departName) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
    }

    public static OrganizationAdminResponse create(String id, String name, String telephone, String departName) {
        return new OrganizationAdminResponse(id, name, telephone, departName);
    }
}
