package com.bcxin.api.interfaces.tenants.responses;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * description：操作日志记录返回对象
 * author：linchunpeng
 * date：2023/12/13
 */
@ApiModel("操作日志记录返回对象")
@Data
public class OperateLogResponse implements Serializable {

    /**
     * 主键
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    private String tenantUserId;

    /**
     * 账号
     */
    @ApiModelProperty(value = "账号")
    private String userName;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String realName;

    /**
     * 操作类型：1登录
     */
    @ApiModelProperty(value = "操作类型：1登录")
    private Integer operateType;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间")
    private String operateTimeStr;

    /**
     * 操作内容
     */
    @ApiModelProperty(value = "操作内容")
    private String operateContent;

    /**
     * 操作结果
     */
    @ApiModelProperty(value = "操作结果")
    private String operateResult;

    /**
     * IP地址
     */
    @ApiModelProperty(value = "IP地址")
    private String ipAddress;

}
