package com.bcxin.api.interfaces.tenants.responses;

import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class DepartAdminGetResponse implements Serializable {
    private final String employeeId;
    private final String name;
    private final String telephone;
    private final String departName;
    private final String managedAdminNames;

    public DepartAdminGetResponse(String employeeId,
                                  String name,
                                  String telephone,
                                  String departName,
                                  String managedAdminNames) {
        this.employeeId = employeeId;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.managedAdminNames = managedAdminNames;
    }

    public String getJoinedManagedAdminName() {
        return managedAdminNames;
    }

    public static DepartAdminGetResponse create(String employeeId,
                                                String name,
                                                String telephone,
                                                String departName,
                                                String managedAdminNames) {
        return new DepartAdminGetResponse(employeeId, name,telephone, departName, managedAdminNames);
    }
}
