package com.bcxin.api.interfaces.tenants.requests.uploads;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class UpdateDepartAdminRequest implements Serializable {
    private final String employeeId;
    private final Collection<String> departIds;

    public UpdateDepartAdminRequest(String employeeId,
                                    Collection<String> departIds) {
        this.employeeId = employeeId;
        this.departIds = departIds;
    }

    public static UpdateDepartAdminRequest create(String employeeId,
                                                  Collection<String> departIds) {
        return new UpdateDepartAdminRequest(employeeId, departIds);
    }
}
