package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@ApiModel("创建团体")
@Data
public class CreateOrganizationRequest extends RequestAbstract {
    @ApiModelProperty(value = "行业类型; 小程序固定传02;保安公司要写01", required = true)
    @NotBlank(message = "行业类型不能为空")
    private String industryCode;

    @ApiModelProperty(value = "机构类型; 根据大活行业的机构类型选项的对应编码值；保安公司机构类型:0102", required = true)
    @NotBlank(message = "机构类型不能为空")
    private String institutionalCode;

    @ApiModelProperty(value = "公司名称", required = true)
    @NotBlank(message = "公司名称不能为空")
    private String name;

    @ApiModelProperty(value = "营业执照编码（来自识别;）", required = false)
    private String unifySocialCreditCode;

    @ApiModelProperty(value = "营业执照扫描件", required = true)
    @NotBlank(message = "营业执照扫描件不能为空")
    private String unifySocialCreditCodeFile;
}
