package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Date;

@Data
public class UpdateEmployeeRequest extends RequestAbstract {
    /**
     * 所属本部门
     */
    @ApiModelProperty(value = "所属本部门")
    private String departId;
    /**
     * 入职时间
     */
    @NotNull
    @ApiModelProperty(value = "入职时间")
    private Date hiredDate;

    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String position;

    /**
     * 上级用户
     */
    @ApiModelProperty(value = "上级用户")
    private String superiorId;

    /**
     * 转正时间
     */
    @ApiModelProperty(value = "转正时间")
    private Date positiveDate;


    /**
     * 所属部门
     */
    @NotEmpty
    @ApiModelProperty(value = "所属部门")
    private Collection<String> departIds;

    /**
     * 面谈记录
     */
    @ApiModelProperty(value = "面谈记录")
    private String interview;

    /**
     * 员工状态（选填，单选：全职/兼职/试用/实习）
     */
    @ApiModelProperty(value = "员工状态")
    private PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    @ApiModelProperty(value = "试用期")
    private String probation;


    /**
     * 原定转正日期 年月日
     */
    @ApiModelProperty(value = "原定转正日期")
    private Date planPositiveDate;

    /**
     * 薪资
     */
    @ApiModelProperty(value = "薪资")
    private String salary;
}
