package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;
import java.util.Collection;

@Getter
public class BatchPermissionRequest extends RequestAbstract {
    private final Collection<String> employeeIds;
    private final Collection<String> roleIds;
    private boolean fromAdmin = false;

    public BatchPermissionRequest(Collection<String> employeeIds, Collection<String> roleIds) {
        this.employeeIds = employeeIds;
        this.roleIds = roleIds;
    }

    public void setFromAdmin(boolean fromAdmin){
        this.fromAdmin = fromAdmin;
    }
}
