package com.bcxin.api.interfaces.tenants.requests.employees;

import lombok.Getter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Getter
public class BatchImportRoleMemberRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String name;
    private final String telephone;

    public BatchImportRoleMemberRequest(String name, String telephone) {
        this.name = name;
        this.telephone = telephone;
    }

    public static BatchImportRoleMemberRequest create(String name, String telephone) {
        return new BatchImportRoleMemberRequest(name, telephone);
    }

    public Map<String, String> toMap() {
        Map<String, String> map = new HashMap<>();
        map.put("name", name);
        map.put("telephone", telephone);
        return map;
    }
}
