package com.bcxin.api.interfaces.tenants.requests.employees;

import lombok.Getter;

import java.io.Serializable;

@Getter
public class BatchImportEmployeeRequest implements Serializable {
    private final String name;
    private final String telephone;
    private final String departName;
    private final String occupationType;
    private final String position;
    private final String hiredDate;
    private final String credentialType;
    private final String credentialNumber;
    private final String nation;
    private final String education;
    private final String politicsStatus;
    private final String militaryStatus;
    private final String maritalStatus;
    private final String emergencyContact;
    private final String emergencyPhone;
    private final String address;
    private final String householdType;

    public BatchImportEmployeeRequest(String name, String telephone, String departName,
                                      String occupationType, String position, String hiredDate,
                                      String credentialType, String credentialNumber, String nation,
                                      String education, String politicsStatus, String militaryStatus, String maritalStatus,
                                      String emergencyContact, String emergencyPhone, String address, String householdType) {
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.occupationType = occupationType;
        this.position = position;
        this.hiredDate = hiredDate;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.address = address;
        this.householdType = householdType;
    }

    public static BatchImportEmployeeRequest create(String name, String telephone, String departName,
                                                    String occupationType, String position, String hiredDate,
                                                    String credentialType, String credentialNumber, String nation,
                                                    String education, String politicsStatus, String militaryStatus, String maritalStatus,
                                                    String emergencyContact, String emergencyPhone, String address, String householdType) {
        return new BatchImportEmployeeRequest(name, telephone, departName, occupationType, position,
                hiredDate, credentialType, credentialNumber, nation, education, politicsStatus, militaryStatus,
                maritalStatus, emergencyContact, emergencyPhone, address, householdType);
    }
}
