package com.bcxin.api.interfaces.rbacs.responses;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class UserDetailGetResponse {
    private final String id;
    private final String referencedId;
    private final String name;
    private final Collection<RoleDetailGetResponse> roles = new ArrayList<>();

    public UserDetailGetResponse(String id, String referencedId, String name) {
        this.id = id;
        this.referencedId = referencedId;
        this.name = name;
    }

    public static UserDetailGetResponse create(String id, String referencedId, String name) {
        return new UserDetailGetResponse(id, referencedId, name);
    }

    public void assignRoleDetail(RoleDetailGetResponse roleDetailGetResponse) {
        this.getRoles().add(roleDetailGetResponse);
    }
}
