package com.bcxin.api.interfaces.rbacs;

import com.bcxin.api.interfaces.rbacs.requests.BatchCategoryResourceRequest;
import com.bcxin.api.interfaces.rbacs.requests.CategoryRequest;
import com.bcxin.api.interfaces.rbacs.responses.CategoryDetailGetResponse;
import com.bcxin.api.interfaces.rbacs.responses.CategoryGetResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface RbacCategoryRpcProvider {
    void create(CategoryRequest request);

    void update(String id, CategoryRequest request);

    void delete(String id);

    Collection<CategoryGetResponse> getAll();

    void batch(BatchCategoryResourceRequest request);

    Collection<CategoryDetailGetResponse> getByIds(Collection<String> ids);

    Collection<CategoryDetailGetResponse> getAllDetails();
}
