package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

@Getter
public class TocUserAssignIdentityRequest extends RequestAbstract {
    private final String tenantUserId;
    private final String openId;

    private final String unionId;

    private final String name;

    private final String phone;

    private final String number;

    public TocUserAssignIdentityRequest(String tenantUserId, String openId, String unionId,
                                        String name, String phone, String number) {
        this.tenantUserId = tenantUserId;
        this.openId = openId;
        this.unionId = unionId;
        this.name = name;
        this.phone = phone;
        this.number = number;
    }

    public static TocUserAssignIdentityRequest create(String tenantUserId, String openId,String unionId,
                                                      String name, String phone, String number) {
        return new TocUserAssignIdentityRequest(tenantUserId, openId,unionId, name, phone, number);
    }
}
