package com.bcxin.api.interfaces.commons;

import com.bcxin.Infrastructures.enums.ProcessedStatus;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Map;

@Getter
public class ImportedResponseItem implements Serializable {
    private final int index;
    private final Map<String, Object> parameters;
    private final String result;
    private final ProcessedStatus status;

    public boolean IsSuccess() {
        return this.getStatus() == ProcessedStatus.Done;
    }

    public ImportedResponseItem(int index, Map<String, Object> parameters, String result, ProcessedStatus status) {
        this.parameters = parameters;

        this.index = index;
        this.status = status;
        if (status == ProcessedStatus.Init) {
            this.result = "未处理";
        } else if (status == ProcessedStatus.Processing) {
            this.result = "处理中";
        } else {
            this.result = result;
        }
    }

    public static ImportedResponseItem create(int index, Map<String, Object> parameters, String result, ProcessedStatus status) {
        return new ImportedResponseItem(index, parameters, result, status);
    }
}
