package com.bcxin.api.interfaces.backends.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class EventSubscriberRequest extends RequestAbstract {
    private final Collection<String> selectors;
    private final String tenantUserId;

    public EventSubscriberRequest(Collection<String> selectors, String tenantUserId) {
        this.selectors = selectors;
        this.tenantUserId = tenantUserId;
    }

    public static EventSubscriberRequest create(Collection<String> selectors, String tenantUserId) {
        return new EventSubscriberRequest(selectors, tenantUserId);
    }
}
