package com.bcxin.api.interfaces;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@Getter
public class SearchRequestAbstract extends RequestAbstract {

    @ApiModelProperty(value = "当前页码; 列表分页及手机滚动分页的时候使用; 必填", required = false)
    private final int pageIndex;
    @ApiModelProperty(value = "每页显示数量; 列表分页及手机滚动分页的时候使用; 必填", required = false)
    private final int pageSize;

    public SearchRequestAbstract(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            this.pageIndex = 1;
        } else {
            this.pageIndex = pageIndex;
        }

        if (pageSize < 1) {
            this.pageSize = 10;
        } else {
            this.pageSize = pageSize;
        }
    }
}
