package com.bcxin.Infrastructures.enums;

/**
 * description: 保安服务公司类型-枚举类
 * author: linchunpeng
 * date:  2023-05-05 10:58
 */
public enum IndustryDetailType implements SwaggerDisplayEnum {

    /**
     * 无
     */
    None{
        @Override
        public String getTypeName(){return "空";}
    },

    /**
     * 普通保安服务公司
     */
    GeneralSecurity{
        @Override
        public String getTypeName(){return "普通保安服务公司";}
    },

    /**
     * 武装守护押运保安服务公司
     */
    ArmedEscort{
        @Override
        public String getTypeName(){return "武装守护押运保安服务公司";}
    },

    /**
     * 外资保安服务公司
     */
    ForeignSecurity{
        @Override
        public String getTypeName(){return "外资保安服务公司";}
    };

    public abstract String getTypeName();


    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }

}
