package com.bcxin.Infrastructures.components.models;

import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;

@Getter
public abstract class CacheItemAbstract<T> implements Serializable {
    private final Timestamp createdTime;
    private int expiredInSeconds;
    private final T data;

    public CacheItemAbstract(T data) {
        this.createdTime = Timestamp.from(Instant.now());
        this.expiredInSeconds = 60 * 10;
        this.data = data;
    }

    public void assignExpiredInSeconds(int seconds) {
        this.expiredInSeconds = seconds;
    }

    public boolean isExpired() {
        Timestamp comparedTime = Timestamp.from(Instant.now().minusSeconds(this.getExpiredInSeconds()));

        return this.createdTime.after(comparedTime);
    }
}
