/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.components.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import org.springframework.util.StringUtils;

public class ForgetPasswordActionExecuteCommand
extends CommandAbstract {
    private final String loginName;
    private final String mobile;
    private final String name;
    private final String dataNoe;
    private final String dataTow;
    private final UserCheckedStatus userCheckedStatus;

    public String getDefaultPassword() {
        String defaultPassword = this.getMobile();
        if (StringUtils.hasLength((String)defaultPassword) && defaultPassword.length() > 0) {
            defaultPassword = defaultPassword.substring(defaultPassword.length() - 6);
        }
        return defaultPassword;
    }

    public void validate() {
        if (!StringUtils.hasLength((String)this.getMobile())) {
            throw new NotSupportTenantException("\u624b\u673a\u53f7\u65e0\u6548\uff01");
        }
    }

    public ForgetPasswordActionExecuteCommand(UserCheckedStatus userCheckedStatus, String loginName, String mobile, String name, String dataNoe, String dataTow) {
        this.loginName = loginName;
        this.mobile = mobile;
        this.name = name;
        this.dataNoe = dataNoe;
        this.dataTow = dataTow;
        this.userCheckedStatus = userCheckedStatus;
    }

    public static ForgetPasswordActionExecuteCommand create(UserCheckedStatus userCheckedStatus, String loginName, String mobile, String name, String dataNoe, String dataTow) {
        return new ForgetPasswordActionExecuteCommand(userCheckedStatus, loginName, mobile, name, dataNoe, dataTow);
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getName() {
        return this.name;
    }

    public String getDataNoe() {
        return this.dataNoe;
    }

    public String getDataTow() {
        return this.dataTow;
    }

    public UserCheckedStatus getUserCheckedStatus() {
        return this.userCheckedStatus;
    }
}

