/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.identity.domains.components.ForgetPasswordExecutorImpl;
import com.bcxin.identity.domains.components.commands.ForgetPasswordActionExecuteCommand;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.utils.JwtUtil;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="FaceIdentityForgetPasswordExecutorImpl")
public class FaceIdentityForgetPasswordExecutorImpl
implements ForgetPasswordExecutorImpl {
    private final String identityWebSite;

    public FaceIdentityForgetPasswordExecutorImpl(@Value(value="${identity.face.website}") String identityWebSite) {
        this.identityWebSite = identityWebSite;
    }

    @Override
    public PrepareResetPasswordCommandResult execute(ForgetPasswordActionExecuteCommand command) {
        if (command.getUserCheckedStatus() != UserCheckedStatus.Matched) {
            return new PrepareResetPasswordCommandResult(null, false, "-3", null);
        }
        HashMap<String, Object> faceParams = new HashMap<String, Object>();
        faceParams.put("oneImg", command.getDataNoe());
        faceParams.put("twoImg", command.getDataTow());
        faceParams.put("bizFaceMode", "UNIAPP");
        faceParams.put("bizFaceMode", "UNIAPP");
        faceParams.put("vtp", 70);
        String facePost = null;
        try {
            facePost = HttpUtil.post((String)this.identityWebSite, faceParams);
            JSONObject faceJsonObject = JSONUtil.parseObj((String)facePost);
            String retType = (String)faceJsonObject.get((Object)"retType");
            if ("0".equals(retType)) {
                JSONObject faceJson = (JSONObject)faceJsonObject.get((Object)"data");
                String faceResult = (String)faceJson.get((Object)"result");
                if ("1".equals(faceResult)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("GetPasswordType", "0");
                    map.put("loginName", command.getLoginName());
                    map.put("time", DateUtil.now());
                    String json = JSON.toJSONString(map);
                    String jwt = JwtUtil.createJwt(json);
                    return new PrepareResetPasswordCommandResult(jwt, true, "200", null);
                }
                return new PrepareResetPasswordCommandResult("\u6bd4\u5bf9\u5931\u8d25,msg:" + faceJson.get((Object)"response"), false, "-1", null);
            }
            return new PrepareResetPasswordCommandResult("\u8c03\u7528\u5931\u8d25", false, "-1", null);
        }
        catch (Exception ex) {
            throw new BadTenantException(String.format("\u4eba\u8138\u627e\u56de\u5bc6\u7801\u53d1\u751f\u5f02\u5e38-API=%s;\u54cd\u5e94\u5185\u5bb9:%s", this.identityWebSite, facePost), ex);
        }
    }
}

