package com.bcxin.identity.domains.utils;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.springframework.stereotype.Component;

public class JwtUtil {
    /**
     * 私钥（测试秘钥）
     * 生产秘钥正式上线提供
     */
    public static final String JWT_SECRET = "xxx_test_secret";

    /**
     * 1小时
     */
    public static final int JWT_REFRESH_TTL = 60 * 60 * 1000;


    /**
     * 创建jwt
     */
    public static String createJwt(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey());
        // 设置过期时间
        long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    /**
     * 解密jwt
     */
    public static String parseJwt(String token) {
        try {
            return Jwts.parser()
                    .setSigningKey(generalKey())
                    .parseClaimsJws(token)
                    .getBody()
                    .getSubject();
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * 由字符串生成加密key
     */
    private static SecretKey generalKey() {
        byte[] encodedKey = Base64.decodeBase64(JwtUtil.JWT_SECRET);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }
}
