package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.JwtUtil;
import com.bcxin.api.interfaces.enums.UpdatePasswordType;
import com.bcxin.identity.domains.utils.SecurityUtil;
import lombok.Getter;

@Getter
public class SignInCommand extends CommandAbstract {
    private final String userName;
    private final String password;
    private final String ipAddress;
    private final boolean isFromMobile;
    private final boolean validPassword;

    public SignInCommand(String userName, String password,boolean isFromMobile,String ipAddress) {
        this.userName = userName;
        this.password = password;
        this.isFromMobile = isFromMobile;
        this.validPassword = true;
        this.ipAddress = ipAddress;
    }

    public SignInCommand(String userName, String password,boolean isFromMobile,boolean validPassword,String ipAddress) {
        this.userName = userName;
        this.password = password;
        this.isFromMobile = isFromMobile;
        this.validPassword = validPassword;
        this.ipAddress = ipAddress;
    }

    public String getDecodedPassword() {
        try {
            String edPassword = this.getPassword();
            if (edPassword != null && edPassword.length() > 2) {
                String lp = edPassword.substring(0, edPassword.length() - 2);
                String rp = edPassword.substring(edPassword.length() - 2, edPassword.length());
                edPassword = SecurityUtil.decodeBASE64(rp + lp);
            }

            return edPassword;
        } catch (Exception ex) {
            throw new BadTenantException("密码无效");
        }
    }

    public static SignInCommand create(String userName, String password,boolean isFromMobile,String ipAddress) {
        return new SignInCommand(userName, password, isFromMobile,ipAddress);
    }

    public static SignInCommand create(String userName, String password,boolean isFromMobile,boolean validPassword,String ipAddress) {
        return new SignInCommand(userName, password, isFromMobile,validPassword,ipAddress);
    }

    @Getter
    public static class SignInCommandResult {
        private final String id;
        private final String name;
        private final String idNum;
        private final String token;
        private final String tenantUserId;
        //修改密码类型，0：无需提示，1：还没修改过密码，2：上次修改密码的时间超过90天
        private final UpdatePasswordType updatePasswordType;


        public SignInCommandResult(String id, String tenantUserId, String name, String idNum, boolean isFromMobile, UpdatePasswordType updatePasswordType) {
            this.id = id;
            this.name = name;
            this.idNum = idNum;
            this.tenantUserId = tenantUserId;
            this.updatePasswordType = updatePasswordType;

            this.token = isFromMobile ?
                    JwtUtil.getMobileToken(tenantUserId) :
                    JwtUtil.getToken(tenantUserId);
        }

        public static SignInCommandResult create(String id, String tenantUserId, String name, String idNum, boolean isFromMobile, UpdatePasswordType updatePasswordType) {
            return new SignInCommandResult(id, tenantUserId, name, idNum, isFromMobile, updatePasswordType);
        }
    }
}
