/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.components;

import com.bcxin.identity.domains.components.PasswordEncoder;
import com.bcxin.identity.domains.enums.AlgorithmType;
import com.bcxin.identity.domains.utils.PasswordUtils;
import com.bcxin.identity.domains.utils.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component
public class DefaultPasswordEncoderImpl
implements PasswordEncoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultPasswordEncoderImpl.class);
    private final Logger logger = LoggerFactory.getLogger(DefaultPasswordEncoderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMatched(String expectedPassword, String actualPassword) {
        boolean bl;
        StopWatch stopWatch;
        boolean isMatched;
        block10: {
            block9: {
                block8: {
                    if (!StringUtils.hasLength((String)actualPassword) || !StringUtils.hasLength((String)expectedPassword)) {
                        return false;
                    }
                    isMatched = true;
                    stopWatch = new StopWatch();
                    stopWatch.start("PasswordUtils.initVerify");
                    if (!PasswordUtils.initVerify(actualPassword, expectedPassword)) break block8;
                    boolean bl2 = true;
                    stopWatch.stop();
                    if (isMatched) return bl2;
                    this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
                    return bl2;
                }
                stopWatch.stop();
                stopWatch.start("SecurityUtil.decryptPassword");
                if (!actualPassword.equals(SecurityUtil.decryptPassword(expectedPassword))) break block9;
                boolean bl3 = true;
                stopWatch.stop();
                if (isMatched) return bl3;
                this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
                return bl3;
            }
            stopWatch.stop();
            stopWatch.start("SecurityUtil.decryptPassword");
            if (!PasswordUtils.validatePassword(actualPassword, expectedPassword)) break block10;
            boolean bl4 = true;
            stopWatch.stop();
            if (isMatched) return bl4;
            this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
            return bl4;
        }
        try {
            stopWatch.stop();
            stopWatch.start("SecurityUtil.encryptOld");
            bl = isMatched = expectedPassword.equals(SecurityUtil.encryptOld(actualPassword));
        }
        catch (Exception ex) {
            try {
                isMatched = false;
                log.error("\u5bc6\u7801\u6bd4\u5bf9\u5f02\u5e38", (Throwable)ex);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                if (isMatched) throw throwable;
                this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
                throw throwable;
            }
            stopWatch.stop();
            if (isMatched) return false;
            this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
            return false;
        }
        stopWatch.stop();
        if (isMatched) return bl;
        this.logger.error("{}-expectedPassword={};actualPassword={};{};", new Object[]{isMatched, expectedPassword, actualPassword, stopWatch});
        return bl;
    }

    @Override
    public String encode(AlgorithmType algorithmType, String password) {
        if (algorithmType == AlgorithmType.SM2) {
            return PasswordUtils.initSign(password);
        }
        return PasswordUtils.entryptPassword(password).get("hashPassword");
    }

    public static void main(String[] args) {
        System.out.println(PasswordUtils.initSign("123456"));
    }
}

