package com.bcxin.autodownloadupload.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.File;
import java.util.Date;

/**
 * description: 推送记录表
 * author: linchunpeng
 * date:  2023-04-21 10:05
 */
@Data
@TableName("push_record")
public class PushRecord {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //zip文件路径
    private String zipPath;

    //解压结果
    private String unzipResult;

    //zip文件解压后路径
    private String unzipPath;

    //本次上传的文件数量
    private Integer uploadFileCount;

    //上传成功的文件数量
    private Integer uploadSuccessFileCount;

    //上传的开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date uploadStartTime;

    //上传的结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date uploadEndTime;

    //文件上传结果
    private String uploadResult;

    //本次执行的sql文件数量
    private Integer sqlFileCount;

    //执行成功的sql文件数量
    private Integer sqlSuccessFileCount;

    //执行sql的开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date sqlStartTime;

    //执行sql的结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date sqlEndTime;

    //sql执行结果
    private String sqlResult;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    /**
     * description: 获取要上传文件的目录
     * author: linchunpeng
     * date:  2023-04-23 16:59
     */
    public String getUploadsPath() {
        return this.getUnzipPath().concat(File.separator).concat("files").concat(File.separator).concat("uploads");
    }

    /**
     * description: 获取pull-download.txt
     * author: linchunpeng
     * date:  2023-04-23 16:59
     */
    public String getDownloadTxtPath() {
        return this.getUnzipPath().concat(File.separator).concat("files").concat(File.separator).concat("pull-download.txt");
    }


    /**
     * description: 获取要sql的目录
     * author: linchunpeng
     * date:  2023-04-23 16:59
     */
    public String geSqlPath() {
        return this.getUnzipPath().concat(File.separator).concat("sql");
    }

    /**
     * description: 获取execute-error.txt
     * author: linchunpeng
     * date:  2023-04-23 16:59
     */
    public String getExecuteErrorTxtPath() {
        return this.getUnzipPath().concat(File.separator).concat("execute-error.txt");
    }
}
