/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.organizationAdmins;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CreateOrganizationAdminCommand
extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;

    public CreateOrganizationAdminCommand(String organizationId, Collection<String> employeeIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
    }

    public static CreateOrganizationAdminCommand create(String organizationId, Collection<String> employeeIds) {
        return new CreateOrganizationAdminCommand(organizationId, employeeIds);
    }

    public void validate() {
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u7ec4\u7ec7Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(this.getEmployeeIds())) {
            throw new ArgumentTenantException("\u804c\u5458Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<String> getEmployeeIds() {
        return this.employeeIds;
    }
}

