/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.contracts;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.domain.entities.ContractEntity;
import java.util.Date;
import java.util.List;
import org.springframework.util.StringUtils;

public class CreateContractCommand
extends CommandAbstract {
    private final String name;
    private final String employeeId;
    private final String organizationId;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean dateLimitless;
    private final String attachment;
    private final String note;

    public CreateContractCommand(String name, String employeeId, String organizationId, String aName, String bName, Date beginDate, Date endDate, boolean dateLimitless, String attachment, String note) {
        this.name = name;
        this.employeeId = employeeId;
        this.organizationId = organizationId;
        this.aName = aName;
        this.bName = bName;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.attachment = attachment;
        this.dateLimitless = dateLimitless;
        this.note = note;
    }

    public static CreateContractCommand create(String name, String employeeId, String organizationId, String aName, String bName, Date beginDate, Date endDate, boolean dateLimitless, String attachment, String note) {
        return new CreateContractCommand(name, employeeId, organizationId, aName, bName, beginDate, endDate, dateLimitless, attachment, note);
    }

    public void validate() {
        super.validate();
        if (!StringUtils.hasLength((String)this.getEmployeeId())) {
            throw new ArgumentTenantException("\u804c\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getName())) {
            throw new ArgumentTenantException("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getAName())) {
            throw new ArgumentTenantException("\u7532\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getBName())) {
            throw new ArgumentTenantException("\u4e59\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getBeginDate() == null) {
            throw new ArgumentTenantException("\u5408\u540c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.isDateLimitless()) {
            if (this.getEndDate() == null) {
                throw new ArgumentTenantException("\u5408\u540c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.getEndDate().before(this.getBeginDate())) {
                throw new ArgumentTenantException("\u5408\u540c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
            }
        }
        if (!StringUtils.hasLength((String)this.getAttachment())) {
            throw new ArgumentTenantException("\u7535\u5b50\u5408\u540c\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void validateExist(List<ContractEntity> contractList) {
        if (contractList == null || contractList.size() == 0) {
            return;
        }
        if (contractList.stream().anyMatch(ii -> this.getBeginDate().getTime() <= ii.getBeginDate().getTime() && this.getEndDate().getTime() > ii.getBeginDate().getTime() || this.getBeginDate().getTime() < ii.getEndDate().getTime() && this.getEndDate().getTime() > ii.getEndDate().getTime() || ii.getBeginDate().getTime() < this.getBeginDate().getTime() && ii.getEndDate().getTime() > this.getBeginDate().getTime() || ii.getBeginDate().getTime() < this.getEndDate().getTime() && ii.getEndDate().getTime() >= this.getEndDate().getTime())) {
            throw new ArgumentTenantException("\u5728\u5408\u540c\u6709\u6548\u671f\u5185\u540c\u4e00\u4e2a\u4eba\u53ea\u80fd\u6709\u4e00\u4efd\u5408\u540c");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getAName() {
        return this.aName;
    }

    public String getBName() {
        return this.bName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isDateLimitless() {
        return this.dateLimitless;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public String getNote() {
        return this.note;
    }
}

